/*
 * @(#)Angle.java Jun 13, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.language.d2;

import java.awt.geom.Point2D;

/**
 * <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version Jun 13, 2004 <br>
 * @author <a
 *         href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 *         Verbraeck </a>
 */
public final class Angle
{
	/**
	 * constructs a new Angle
	 */
	private Angle()
	{
		super();
		//unreachable code
	}

	/**
	 * Normalize an angle between 0 and 2*pi
	 * 
	 * @param angle the angle to normalize
	 * @return normalized angle
	 */
	public static double normalize2Pi(final double angle)
	{
		double result = angle + 2.0d * Math.PI;
		double times = Math.floor(result / (2.0d * Math.PI));
		result -= times * 2.0d * Math.PI;
		return result;
	}

	/**
	 * Normalize an angle between -pi and +pi
	 * 
	 * @param angle the angle to normalize
	 * @return normalized angle
	 */
	public static double normalizePi(final double angle)
	{
		double result = angle + 2.0d * Math.PI;
		double times = Math.floor((result + Math.PI) / (2.0d * Math.PI));
		result -= times * 2.0d * Math.PI;
		return result;
	}

	/**
	 * Return the 2-pi normalized angle when making an arc from p0 to p1
	 * 
	 * @param p0 first point
	 * @param p1 second point
	 * @return the normalized angle
	 */
	public static double angle(final Point2D p0, final Point2D p1)
	{
		return normalize2Pi(Math.atan2(p1.getY() - p0.getY(), p1.getX()
				- p0.getX()));
	}
}