/*
 * @(#) CompositeFilter.java Oct 26, 2004
 * 
 * Copyright (c) 2004 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.language.filters;

/**
 * The composite filter combines two filters.
 * <p>
 * (c) copyright 2004 <a href="http://www.simulation.tudelft.nl/dsol/">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl/dsol/">
 * www.simulation.tudelft.nl/dsol </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a
 *         href="http://web.eur.nl/fbk/dep/dep1/Introduction/Staff/People/Lang">Niels
 *         Lang </a><a
 *         href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>
 * @version 1.0 Oct 26, 2004
 * @since 1.2
 */
public class CompositeFilter extends AbstractFilter
{
	/** the ADD operator */
	public static final short ADD = 0;

	/** the OR operator */
	public static final short OR = 1;

	/** the operator of the composite filter */
	private short operator = -1;

	/** the filters to compose */
	private Filterinterface[] filters = new Filterinterface[2];

	/**
	 * constructs a new CompositeFilter
	 * 
	 * @param filter1 the first filter
	 * @param filter2 the second filter
	 * @param operator the operator (AND or OR)
	 */
	public CompositeFilter(Filterinterface filter1, Filterinterface filter2,
			short operator)
	{
		super();
		if (operator < 0 || operator > 1)
		{
			throw new IllegalArgumentException("unknown operator");
		}
		this.filters[0] = filter1;
		this.filters[1] = filter2;
		this.operator = operator;
	}

	/**
	 * @see nl.tudelft.simulation.language.filters.AbstractFilter#filter(java.lang.Object)
	 */
	protected boolean filter(Object entry)
	{
		if (this.operator == CompositeFilter.ADD)
		{
			return this.filters[0].accept(entry)
					&& this.filters[1].accept(entry);
		}
		return this.filters[0].accept(entry) || this.filters[1].accept(entry);
	}

	/**
	 * @see nl.tudelft.simulation.language.filters.AbstractFilter#getCriterium()
	 */
	public String getCriterium()
	{
		return "composed[" + this.filters[0].getCriterium() + ";"
				+ this.filters[0].getCriterium() + ";" + this.operator + "]";
	}
}
