/*
 * @(#) Filterinterface.java Oct 26, 2004
 * 
 * Copyright (c) 2004 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.language.filters;

/**
 * The FilterInterface is a general interface for all filters in DSOL. Filters
 * can be based on xY combinations, class information ,etc. etc. The API of
 * implementing filters will explain what it expects as input.
 * <p>
 * (c) copyright 2004 <a href="http://www.simulation.tudelft.nl/dsol/">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl/dsol/">
 * www.simulation.tudelft.nl/dsol </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a
 *         href="http://web.eur.nl/fbk/dep/dep1/Introduction/Staff/People/Lang">Niels
 *         Lang </a><a
 *         href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>
 * @version 1.0 Oct 26, 2004
 * @since 1.2
 */
public interface Filterinterface
{
	/**
	 * a filter defines whether to accept a value in a chart
	 * 
	 * @param entry the entry to filter
	 * @return whether to accept this entry
	 */
	public boolean accept(Object entry);

	/**
	 * inverts the filter
	 * 
	 * @param inverted whether to invert the filter
	 */
	public void setInverted(boolean inverted);

	/**
	 * is the filter inverted?
	 * 
	 * @return whether the filter is inverted.
	 */
	public boolean isInverted();

	/**
	 * returns a string representation of the criterium
	 * 
	 * @return the string representing the criterium
	 */
	public String getCriterium();

	/**
	 * adds filter to this filter and returns the composed filter
	 * 
	 * @param filter the filter to add
	 * @return the composed filter
	 */
	public Filterinterface add(Filterinterface filter);

	/**
	 * creates a new composite filter which is one or two
	 * 
	 * @param filter the filter to add
	 * @return the composed filter
	 */
	public Filterinterface or(Filterinterface filter);
}