/*
 * @(#) ModulusFilter.java Oct 26, 2004
 * 
 * Copyright (c) 2004 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.language.filters;


/**
 * The modulus filter only accepts
 * <p>
 * (c) copyright 2004 <a href="http://www.simulation.tudelft.nl/dsol/">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl/dsol/">
 * www.simulation.tudelft.nl/dsol </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm"> Peter
 *         Jacobs </a>
 * @version 1.0 Oct 26, 2004
 * @since 1.2
 */
public class ModulusFilter extends AbstractFilter
{
	/** the maxPoints to use */
	private long modulus = -1;

	/** the amount of points already accepted */
	private long current = -1;

	/**
	 * constructs a new ModulusFilter
	 * 
	 * @param modulus the modulus to use
	 */
	public ModulusFilter(final long modulus)
	{
		super();
		this.modulus = modulus;
	}


	/**
	 * @see nl.tudelft.simulation.language.filters.AbstractFilter#filter(java.lang.Object)
	 */
	protected synchronized boolean filter(final Object entry)
	{
		this.current++;
		if (this.current % this.modulus == 0)
		{
			return true;
		}
		return false;
	}

	/**
	 * @see nl.tudelft.simulation.language.filters.Filterinterface#getCriterium()
	 */
	public String getCriterium()
	{
		return "accepts every " + this.modulus + "nth entry";
	}
}