/*
 * @(#) ZeroFilter.java Oct 26, 2004
 * 
 * Copyright (c) 2004 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.language.filters;


/**
 * The Zero filter does not filter any value.
 * <p>
 * (c) copyright 2004 <a href="http://www.simulation.tudelft.nl/dsol/">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl/dsol/">
 * www.simulation.tudelft.nl/dsol </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm"> Peter
 *         Jacobs </a>
 * @version 1.0 Oct 26, 2004
 * @since 1.2
 */
public class ZeroFilter extends AbstractFilter
{
	/**
	 * constructs a new ZeroFilte
	 */
	public ZeroFilter()
	{
		super();
	}

	/**
	 * @see nl.tudelft.simulation.language.filters.AbstractFilter#filter(java.lang.Object)
	 * @return whether to accept the value; null values are accepted.
	 */
	protected boolean filter(final Object entry)
	{
		return true;
	}

	/**
	 * @see nl.tudelft.simulation.language.filters.Filterinterface#getCriterium()
	 */
	public String getCriterium()
	{
		return "accepts every entry";
	}
}