/*
 * @(#) URLResource.java Jun 17, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.language.io;

import java.io.File;
import java.io.InputStream;
import java.net.URL;

/**
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>
 * @version 1.2 Jun 17, 2004
 * @since 1.4
 */
public final class URLResource
{
	/**
	 * constructs a new URLResource
	 */
	private URLResource()
	{
		super();
		//unreachable code
	}

	/**
	 * resolves a resource for name
	 * 
	 * @param name the name to search for
	 * @return the resolved URL
	 */
	public static URL getResource(final String name)
	{
		try
		{
			if (name.startsWith("/"))
			{
				URL url = URLResource.class.getResource(name);
				if (url != null)
				{
					return url;
				}
				url = Thread.currentThread().getContextClassLoader()
						.getResource(name.substring(1));
				if (url != null)
				{
					return url;
				}
				File file = new File(name);
				if (file.exists())
				{
					return new URL("file:" + name);
				}
			} else
			{
				return new URL(name);
			}
		} catch (Exception exception)
		{
			exception = null;
			//We neglect exceptions since we return null
		}
		return null;
	}

	/**
	 * returns the reseource as stream
	 * 
	 * @param name the name of the resource
	 * @return the inputStream
	 */
	public static InputStream getResourceAsStream(final String name)
	{
		try
		{
			URL url = URLResource.getResource(name);
			if (url == null)
			{
				return null;
			}
			return url.openStream();
		} catch (Exception exception)
		{
			return null;
		}
	}
}