/*
 * @(#) ZeroFilterTest.java Sep 28, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.language.filters;

import junit.framework.Assert;
import junit.framework.TestCase;

/**
 * Tests the ZeroFilter.
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>
 * @version 1.2 Sep 28, 2004
 * @since 1.4
 */
public class ZeroFilterTest extends TestCase
{
	/**
	 * constructs a new ZeroFilterTest
	 */
	public ZeroFilterTest()
	{
		this("test");
	}

	/**
	 * constructs a new ZeroFilterTest
	 * 
	 * @param arg0
	 */
	public ZeroFilterTest(String arg0)
	{
		super(arg0);
	}

	/**
	 * tests the ZeroFilter.
	 */
	public void test()
	{
		Filterinterface filter = new ZeroFilter();
		Assert.assertTrue(filter.accept(null));
		Assert.assertTrue(filter.accept("entry"));

		//Let's put the filter on inverted mode
		filter.setInverted(true);
		Assert.assertFalse(filter.accept(null));
		Assert.assertFalse(filter.accept("entry"));

		//Let's test AND
		filter = filter.add(new ZeroFilter());
		Assert.assertFalse(filter.accept("entry"));

		//Let's test OR
		Filterinterface filter1 = new ZeroFilter();
		Filterinterface filter2 = new ZeroFilter();
		filter2.setInverted(true);
		filter = filter1.or(filter2);
		Assert.assertTrue(filter.accept("entry"));
	}
}