/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.filters;

import nl.tudelft.simulation.language.filters.AbstractFilter;
import nl.tudelft.simulation.language.filters.Filterinterface;

public class CompositeFilter
extends AbstractFilter {
    public static final short ADD = 0;
    public static final short OR = 1;
    private short operator = (short)-1;
    private Filterinterface[] filters = new Filterinterface[2];

    public CompositeFilter(Filterinterface filter1, Filterinterface filter2, short operator) {
        if (operator < 0 || operator > 1) {
            throw new IllegalArgumentException("unknown operator");
        }
        this.filters[0] = filter1;
        this.filters[1] = filter2;
        this.operator = operator;
    }

    protected boolean filter(Object entry) {
        if (this.operator == 0) {
            return this.filters[0].accept(entry) && this.filters[1].accept(entry);
        }
        return this.filters[0].accept(entry) || this.filters[1].accept(entry);
    }

    public String getCriterium() {
        return "composed[" + this.filters[0].getCriterium() + ";" + this.filters[0].getCriterium() + ";" + this.operator + "]";
    }
}

