/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nl.tudelft.simulation.language.primitives.Primitive;
import nl.tudelft.simulation.language.reflection.FieldSignature;

public final class ClassUtil {
    private static Map cache = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$0;

    private ClassUtil() {
    }

    public static Constructor[] getAllConstructors(Class clazz, Constructor[] result) {
        ArrayList<Constructor> list = new ArrayList<Constructor>(Arrays.asList(result));
        list.addAll(Arrays.asList(clazz.getDeclaredConstructors()));
        if (clazz.getSuperclass() != null) {
            return ClassUtil.getAllConstructors(clazz.getSuperclass(), list.toArray(new Constructor[list.size()]));
        }
        return list.toArray(new Constructor[list.size()]);
    }

    public static Constructor resolveConstructor(Class clazz, Class callerClass, Class[] parameterTypes) throws NoSuchMethodException {
        Constructor constructor = ClassUtil.resolveConstructor(clazz, parameterTypes);
        if (ClassUtil.isVisible(constructor, callerClass.getClass())) {
            return constructor;
        }
        throw new NoSuchMethodException("constructor resolved but not visible");
    }

    public static Constructor resolveConstructor(Class clazz, Class[] parameterTypes) throws NoSuchMethodException {
        try {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ClassUtil.resolveConstructorSuper(clazz, (Class[])ClassUtil.checkInput(parameterTypes, clazz2));
        }
        catch (Exception exception) {
            String className = clazz.getName();
            if (className.indexOf("$") >= 0) {
                Class<?> parentClass = null;
                try {
                    parentClass = Class.forName(className.substring(0, className.lastIndexOf("$")));
                }
                catch (Exception e2) {
                    throw new NoSuchMethodException("class " + parentClass + " not found to resolve constructor");
                }
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("java.lang.Class");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ClassUtil.resolveConstructor(parentClass, (Class[])ClassUtil.checkInput(parameterTypes, clazz3));
            }
            throw new NoSuchMethodException("class " + clazz + " does not contain constructor");
        }
    }

    public static Constructor resolveConstructor(Class clazz, Object[] arguments) throws NoSuchMethodException {
        Class[] parameterTypes = ClassUtil.getClass(arguments);
        String key = "CONSTRUCTOR:" + clazz.getClass() + "@" + FieldSignature.toDescriptor(parameterTypes);
        if (cache.containsKey(key)) {
            return (Constructor)cache.get(key);
        }
        try {
            return ClassUtil.resolveConstructor(clazz, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor[] constructors = ClassUtil.getAllConstructors(clazz, new Constructor[0]);
            constructors = ClassUtil.matchSignature(constructors, parameterTypes);
            Constructor result = ClassUtil.getSpecificConstructor(constructors);
            cache.put(key, result);
            return result;
        }
    }

    public static Field resolveField(Class clazz, String fieldName) throws NoSuchFieldException {
        try {
            return ClassUtil.resolveFieldSuper(clazz, fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            String className = clazz.getName();
            if (className.indexOf("$") >= 0) {
                Class<?> clazz2 = null;
                try {
                    clazz2 = Class.forName(className.substring(0, className.lastIndexOf("$")));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoSuchFieldException("class " + clazz + " not found to resolve field " + fieldName);
                }
                return ClassUtil.resolveField(clazz2, fieldName);
            }
            throw new NoSuchFieldException("class " + clazz + " does not contain field " + fieldName);
        }
    }

    public static Field resolveField(Class clazz, Class callerClass, String name) throws NoSuchFieldException {
        Field field = ClassUtil.resolveField(clazz, name);
        if (ClassUtil.isVisible(field, callerClass.getClass())) {
            return field;
        }
        throw new NoSuchFieldException("field resolved but not visible");
    }

    public static Field resolveField(Object object, String fieldName) throws NoSuchFieldException {
        if (object == null) {
            throw new NoSuchFieldException("resolveField: object is null for field " + fieldName);
        }
        return ClassUtil.resolveField(object.getClass(), fieldName);
    }

    public static Method[] getAllMethods(Class clazz, String name, Method[] result) {
        ArrayList<Method> list = new ArrayList<Method>(Arrays.asList(result));
        Method[] methods = clazz.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(name)) {
                list.add(methods[i]);
            }
            ++i;
        }
        if (clazz.getSuperclass() != null) {
            return ClassUtil.getAllMethods(clazz.getSuperclass(), name, list.toArray(new Method[list.size()]));
        }
        return list.toArray(new Method[list.size()]);
    }

    public static Method resolveMethod(Class clazz, Class callerClass, String name, Class[] parameterTypes) throws NoSuchMethodException {
        Method method = ClassUtil.resolveMethod(clazz, name, parameterTypes);
        if (ClassUtil.isVisible(method, callerClass)) {
            return method;
        }
        throw new NoSuchMethodException("method found but not visible");
    }

    public static Method resolveMethod(Class clazz, String name, Class[] parameterTypes) throws NoSuchMethodException {
        try {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ClassUtil.resolveMethodSuper(clazz, name, (Class[])ClassUtil.checkInput(parameterTypes, clazz2));
        }
        catch (Exception exception) {
            String className = clazz.getName();
            if (className.indexOf("$") >= 0) {
                Class<?> parentClass = null;
                try {
                    parentClass = Class.forName(className.substring(0, className.lastIndexOf("$")));
                }
                catch (Exception e2) {
                    throw new NoSuchMethodException("class " + parentClass + " not found to resolve method " + name);
                }
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("java.lang.Class");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ClassUtil.resolveMethod(parentClass, name, (Class[])ClassUtil.checkInput(parameterTypes, clazz3));
            }
            throw new NoSuchMethodException("class " + clazz + " does not contain method " + name);
        }
    }

    public static Method resolveMethod(Object object, String name, Class[] parameterTypes) throws NoSuchMethodException {
        if (object == null) {
            throw new NoSuchMethodException("resolveField: object is null for method " + name);
        }
        return ClassUtil.resolveMethod(object.getClass(), name, parameterTypes);
    }

    public static Method resolveMethod(Object object, String name, Object[] arguments) throws NoSuchMethodException {
        Class[] parameterTypes = ClassUtil.getClass(arguments);
        String key = "METHOD:" + object.getClass() + "@" + name + "@" + FieldSignature.toDescriptor(parameterTypes);
        if (cache.containsKey(key)) {
            return (Method)cache.get(key);
        }
        try {
            return ClassUtil.resolveMethod(object, name, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method[] methods = ClassUtil.getAllMethods(object.getClass(), name, new Method[0]);
            if (methods.length == 0) {
                throw new NoSuchMethodException("No such method: " + name + " for object " + object);
            }
            if ((methods = ClassUtil.matchSignature(methods, name, parameterTypes)).length == 0) {
                throw new NoSuchMethodException("No method with right signature: " + name + " for object " + object);
            }
            Method result = ClassUtil.getSpecificMethod(methods);
            cache.put(key, result);
            return result;
        }
    }

    public static boolean isVisible(int modifiers, Class declaringClass, Class caller) {
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        if (Modifier.isProtected(modifiers)) {
            if (declaringClass.isAssignableFrom(caller)) {
                return true;
            }
            return declaringClass.getPackage().equals(caller.getPackage());
        }
        return declaringClass.equals(caller);
    }

    public static boolean isMoreSpecific(Class[] a, Class[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!b[i].isAssignableFrom(a[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isMoreSpecific(Constructor a, Constructor b) {
        if (a.getParameterTypes().equals(b.getParameterTypes()) && b.getDeclaringClass().isAssignableFrom(a.getDeclaringClass())) {
            return true;
        }
        return ClassUtil.isMoreSpecific(a.getParameterTypes(), b.getParameterTypes());
    }

    public static boolean isMoreSpecific(Method a, Method b) {
        if (!a.getName().equals(b.getName())) {
            return false;
        }
        return ClassUtil.isMoreSpecific(a.getParameterTypes(), b.getParameterTypes());
    }

    public static boolean isVisible(Field field, Class caller) {
        return ClassUtil.isVisible(field.getModifiers(), field.getDeclaringClass(), caller);
    }

    public static boolean isVisible(Constructor constructor, Class caller) {
        return ClassUtil.isVisible(constructor.getModifiers(), constructor.getDeclaringClass(), caller);
    }

    public static boolean isVisible(Method method, Class caller) {
        return ClassUtil.isVisible(method.getModifiers(), method.getDeclaringClass(), caller);
    }

    public static Method[] matchSignature(Method[] methods, String name, Class[] argTypes) {
        ArrayList<Method> results = new ArrayList<Method>();
        int i = 0;
        while (i < methods.length) {
            if (ClassUtil.matchSignature(methods[i], name, argTypes)) {
                results.add(methods[i]);
            }
            ++i;
        }
        return results.toArray(new Method[results.size()]);
    }

    public static boolean matchSignature(Method method, String name, Class[] argTypes) {
        if (!method.getName().equals(name)) {
            return false;
        }
        if (method.getParameterTypes().length != argTypes.length) {
            return false;
        }
        Class<?>[] types = method.getParameterTypes();
        int i = 0;
        while (i < method.getParameterTypes().length) {
            if (!types[i].isAssignableFrom(argTypes[i]) && !types[i].equals(Primitive.getPrimitive(argTypes[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean matchSignature(Constructor constructor, Class[] argTypes) {
        if (constructor.getParameterTypes().length != argTypes.length) {
            return false;
        }
        Class<?>[] types = constructor.getParameterTypes();
        int i = 0;
        while (i < constructor.getParameterTypes().length) {
            if (!types[i].isAssignableFrom(argTypes[i]) && !types[i].equals(Primitive.getPrimitive(argTypes[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Constructor[] matchSignature(Constructor[] constructors, Class[] argTypes) {
        ArrayList<Constructor> results = new ArrayList<Constructor>();
        int i = 0;
        while (i < constructors.length) {
            if (ClassUtil.matchSignature(constructors[i], argTypes)) {
                results.add(constructors[i]);
            }
            ++i;
        }
        return results.toArray(new Constructor[results.size()]);
    }

    public static Class[] getClass(Object[] array) {
        if (array == null) {
            return new Class[0];
        }
        Class[] result = new Class[array.length];
        int i = 0;
        while (i < result.length) {
            result[i] = array[i] == null ? null : array[i].getClass();
            ++i;
        }
        return result;
    }

    private static Object checkInput(Object[] array, Class myClass) {
        if (array != null) {
            return array;
        }
        return Array.newInstance(myClass, 0);
    }

    private static Constructor getSpecificConstructor(Constructor[] methods) throws NoSuchMethodException {
        if (methods.length == 0) {
            throw new NoSuchMethodException();
        }
        if (methods.length == 1) {
            return methods[0];
        }
        int resultID = 0;
        while (resultID < methods.length) {
            boolean success = true;
            int i = 0;
            while (i < methods.length) {
                if (resultID != i && !ClassUtil.isMoreSpecific(methods[resultID], methods[i])) {
                    success = false;
                }
                ++i;
            }
            if (success) {
                return methods[resultID];
            }
            ++resultID;
        }
        throw new NoSuchMethodException();
    }

    private static Method getSpecificMethod(Method[] methods) throws NoSuchMethodException {
        if (methods.length == 0) {
            throw new NoSuchMethodException();
        }
        if (methods.length == 1) {
            return methods[0];
        }
        int resultID = 0;
        while (resultID < methods.length) {
            boolean success = true;
            int i = 0;
            while (i < methods.length) {
                if (resultID != i && !ClassUtil.isMoreSpecific(methods[resultID], methods[i])) {
                    success = false;
                }
                ++i;
            }
            if (success) {
                return methods[resultID];
            }
            ++resultID;
        }
        throw new NoSuchMethodException();
    }

    private static Constructor resolveConstructorSuper(Class clazz, Class[] parameterTypes) throws NoSuchMethodException {
        try {
            String key = "CONSTRUCTOR:" + clazz + "@" + FieldSignature.toDescriptor(parameterTypes);
            if (cache.containsKey(key)) {
                return (Constructor)cache.get(key);
            }
            Constructor constructor = clazz.getDeclaredConstructor(parameterTypes);
            cache.put(key, constructor);
            return constructor;
        }
        catch (Exception exception) {
            if (clazz.getSuperclass() != null) {
                return ClassUtil.resolveConstructorSuper(clazz.getSuperclass(), parameterTypes);
            }
            throw new NoSuchMethodException(exception.getMessage());
        }
    }

    private static Method resolveMethodSuper(Class clazz, String name, Class[] parameterTypes) throws NoSuchMethodException {
        try {
            String key = "METHOD:" + clazz + "@" + name + "@" + FieldSignature.toDescriptor(parameterTypes);
            if (cache.containsKey(key)) {
                return (Method)cache.get(key);
            }
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            cache.put(key, method);
            return method;
        }
        catch (Exception exception) {
            if (clazz.getSuperclass() != null) {
                return ClassUtil.resolveMethodSuper(clazz.getSuperclass(), name, parameterTypes);
            }
            throw new NoSuchMethodException(exception.getMessage());
        }
    }

    private static Field resolveFieldSuper(Class clazz, String fieldName) throws NoSuchFieldException {
        try {
            if (cache.containsKey("FIELD:" + clazz + "@" + fieldName)) {
                return (Field)cache.get("FIELD:" + clazz + "@" + fieldName);
            }
            Field result = clazz.getDeclaredField(fieldName);
            cache.put("FIELD:" + clazz + "@" + fieldName, result);
            return result;
        }
        catch (Exception e) {
            if (clazz.getSuperclass() != null) {
                return ClassUtil.resolveFieldSuper(clazz.getSuperclass(), fieldName);
            }
            throw new NoSuchFieldException("class " + clazz + " does not contain field " + fieldName);
        }
    }
}

