/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.d2;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public final class DirectionalLine
extends Line2D.Double {
    public static final int BACKSIDE = -1;
    public static final int COLLINEAR = 0;
    public static final int FRONTSIDE = 1;
    public static final int SPANNING = 2;
    private double lineThickness = 1.0;
    private double normalX;
    private double normalY;

    public DirectionalLine(double x1, double y1, double x2, double y2) {
        this.setLine(x1, y1, x2, y2);
    }

    public void calcNormal() {
        this.normalX = this.y2 - this.y1;
        this.normalY = this.x1 - this.x2;
    }

    public void normalize() {
        double length = Math.sqrt(this.normalX * this.normalX + this.normalY * this.normalY);
        this.normalX /= length;
        this.normalY /= length;
    }

    public void setLine(float x1, float y1, float x2, float y2) {
        super.setLine(x1, y1, x2, y2);
        this.calcNormal();
    }

    public void setLine(double x1, double y1, double x2, double y2) {
        super.setLine(x1, y1, x2, y2);
        this.calcNormal();
    }

    public void flip() {
        double tx = this.x1;
        double ty = this.y1;
        this.x1 = this.x2;
        this.y1 = this.y2;
        this.x2 = tx;
        this.y2 = ty;
        this.normalX = -this.normalX;
        this.normalY = -this.normalY;
    }

    public boolean equalsCoordinates(DirectionalLine line) {
        return this.x1 == line.x1 && this.x2 == line.x2 && this.y1 == line.y1 && this.y2 == line.y2;
    }

    public boolean equalsCoordinatesIgnoreOrder(DirectionalLine line) {
        return this.equalsCoordinates(line) || this.x1 == line.x2 && this.x2 == line.x1 && this.y1 == line.y2 && this.y2 == line.y1;
    }

    public String toString() {
        return "(" + this.x1 + ", " + this.y1 + ")->" + "(" + this.x2 + "," + this.y2 + ")";
    }

    public int getSideThick(double x, double y) {
        int backSide;
        double normalX = this.normalX * this.lineThickness;
        double normalY = this.normalY * this.lineThickness;
        int frontSide = this.getSideThin(x - normalX / 2.0, y - normalY / 2.0);
        if (frontSide == 1) {
            return 1;
        }
        if (frontSide == -1 && (backSide = this.getSideThin(x + normalX / 2.0, y + normalY / 2.0)) == -1) {
            return -1;
        }
        return 0;
    }

    public int getSideThin(double x, double y) {
        double side = (x - this.x1) * this.normalX + (y - this.y1) * this.normalY;
        if (side < 0.0) {
            return -1;
        }
        if (side > 0.0) {
            return 1;
        }
        return 0;
    }

    public int getSide(Line2D.Double line) {
        int p2Side;
        if (this.x1 == line.x1 && this.x2 == line.x2 && this.y1 == line.y1 && this.y2 == line.y2) {
            return 0;
        }
        int p1Side = this.getSideThick(line.x1, line.y1);
        if (p1Side == (p2Side = this.getSideThick(line.x2, line.y2))) {
            return p1Side;
        }
        if (p1Side == 0) {
            return p2Side;
        }
        if (p2Side == 0) {
            return p1Side;
        }
        return 2;
    }

    public double getIntersection(Line2D.Double line) {
        double denominator = (line.y2 - line.y1) * (this.x2 - this.x1) - (line.x2 - line.x1) * (this.y2 - this.y1);
        if (denominator == 0.0) {
            return -1.0;
        }
        double numerator = (line.x2 - line.x1) * (this.y1 - line.y1) - (line.y2 - line.y1) * (this.x1 - line.x1);
        return numerator / denominator;
    }

    public Point2D.Double getIntersectionPoint(Line2D.Double line) {
        double fraction = this.getIntersection(line);
        Point2D.Double intersection = new Point2D.Double();
        intersection.setLocation(this.x1 + fraction * (this.x2 - this.x1), this.y1 + fraction * (this.y2 - this.y1));
        return intersection;
    }

    public double getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(double lineThickness) {
        this.lineThickness = lineThickness;
    }

    public double getNormalx() {
        return this.normalX;
    }

    public double getNormaly() {
        return this.normalY;
    }
}

