/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.primitives;

public final class Primitive {
    private Primitive() {
    }

    public static Object[] cast(Class[] classes, Object[] values) {
        for (int i = 0; i < classes.length; ++i) {
            values[i] = Primitive.cast(classes[i], values[i]);
        }
        return values;
    }

    public static Object cast(Class clazz, Object object) {
        if (clazz.isInstance(object) || !clazz.isPrimitive() || clazz.equals(Primitive.getPrimitive(object.getClass()))) {
            return object;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return Primitive.toBoolean(object);
        }
        if (clazz.equals(Character.TYPE)) {
            return Primitive.toCharacter(object);
        }
        if (clazz.equals(Byte.TYPE)) {
            return Primitive.toByte(object);
        }
        if (clazz.equals(Double.TYPE)) {
            return Primitive.toDouble(object);
        }
        if (clazz.equals(Float.TYPE)) {
            return Primitive.toFloat(object);
        }
        if (clazz.equals(Long.TYPE)) {
            return Primitive.toLong(object);
        }
        if (clazz.equals(Integer.TYPE)) {
            return Primitive.toInteger(object);
        }
        if (clazz.equals(Short.TYPE)) {
            return Primitive.toShort(object);
        }
        return object;
    }

    public static Class forName(String className) {
        if (className.equals("int") || className.equals("I")) {
            return Integer.TYPE;
        }
        if (className.equals("double") || className.equals("D")) {
            return Double.TYPE;
        }
        if (className.equals("byte") || className.equals("B")) {
            return Byte.TYPE;
        }
        if (className.equals("float") || className.equals("F")) {
            return Float.TYPE;
        }
        if (className.equals("long") || className.equals("J")) {
            return Long.TYPE;
        }
        if (className.equals("boolean") || className.equals("Z")) {
            return Boolean.TYPE;
        }
        if (className.equals("char") || className.equals("C")) {
            return Character.TYPE;
        }
        if (className.equals("short") || className.equals("S")) {
            return Short.TYPE;
        }
        if (className.equals("void") || className.equals("V")) {
            return Void.TYPE;
        }
        return null;
    }

    public static Class getPrimitive(Class wrapperClass) {
        if (wrapperClass.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (wrapperClass.equals(Double.class)) {
            return Double.TYPE;
        }
        if (wrapperClass.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (wrapperClass.equals(Float.class)) {
            return Float.TYPE;
        }
        if (wrapperClass.equals(Long.class)) {
            return Long.TYPE;
        }
        if (wrapperClass.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (wrapperClass.equals(Character.class)) {
            return Character.TYPE;
        }
        if (wrapperClass.equals(Short.class)) {
            return Short.TYPE;
        }
        return null;
    }

    public static Class getWrapper(Class primitiveClass) {
        if (primitiveClass.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (primitiveClass.equals(Double.TYPE)) {
            return Double.class;
        }
        if (primitiveClass.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (primitiveClass.equals(Float.TYPE)) {
            return Float.class;
        }
        if (primitiveClass.equals(Long.TYPE)) {
            return Long.class;
        }
        if (primitiveClass.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (primitiveClass.equals(Character.TYPE)) {
            return Character.class;
        }
        if (primitiveClass.equals(Short.TYPE)) {
            return Short.class;
        }
        throw new IllegalArgumentException(primitiveClass + " != primitive");
    }

    public static Boolean toBoolean(Object object) {
        if (object instanceof Number) {
            int value = ((Number)object).intValue();
            if (value == 1) {
                return Boolean.TRUE;
            }
            if (value == 0) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("object.intValue !=0 && !=1");
        }
        return (Boolean)object;
    }

    public static Byte toByte(Object object) {
        if (object instanceof Number) {
            return new Byte(((Number)object).byteValue());
        }
        return (Byte)object;
    }

    public static Character toCharacter(Object object) {
        if (object instanceof Number) {
            return new Character((char)((Number)object).byteValue());
        }
        return (Character)object;
    }

    public static Double toDouble(Object object) {
        return new Double(((Number)object).doubleValue());
    }

    public static Float toFloat(Object object) {
        return new Float(((Number)object).floatValue());
    }

    public static Long toLong(Object object) {
        return new Long(((Number)object).longValue());
    }

    public static Short toShort(Object object) {
        return new Short(((Number)object).shortValue());
    }

    public static Integer toInteger(Object object) {
        if (object instanceof Character) {
            return new Integer(((Character)object).charValue());
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return new Integer(1);
            }
            return new Integer(0);
        }
        return new Integer(((Number)object).intValue());
    }
}

