/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.logger.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.logger.formatters.StyledTextFormatter;
import nl.tudelft.simulation.logger.handlers.EventLogHandler;
import nl.tudelft.simulation.logger.handlers.MemoryHandler;

public class LogPanel
extends JPanel
implements EventListenerInterface {
    private int bufferSize = 10000;
    private java.util.logging.Logger logger = null;
    private EventLogHandler handler = null;
    private JCheckBox autoCheck = null;
    private JTextPane textPane = new JTextPane();
    private int row = 0;

    public LogPanel(java.util.logging.Logger logger) {
        this.logger = logger;
        this.initializePanel();
        this.initializeLogger();
    }

    public synchronized void finalize() {
        if (this.handler != null) {
            Handler[] handlers = this.logger.getHandlers();
            if (handlers.length == 1) {
                this.logger.addHandler(new MemoryHandler());
            }
            this.logger.removeHandler(this.handler);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(EventInterface event) {
        if (!event.getType().equals((Object)EventLogHandler.LOG_RECORD_PRODUCED_EVENT)) {
            return;
        }
        try {
            Document document = this.textPane.getDocument();
            synchronized (document) {
                ++this.row;
                Record[] records = this.constructMessage((String)event.getContent());
                for (int i = records.length - 1; i > -1; --i) {
                    this.textPane.getDocument().insertString(0, records[i].getMessage(), records[i].getStyle());
                }
                this.textPane.getDocument().insertString(0, "(" + this.row + ")  ", records[0].getStyle());
                if (this.autoCheck.isSelected() && this.textPane.getDocument().getLength() > this.bufferSize) {
                    this.textPane.getDocument().remove(this.bufferSize, this.textPane.getDocument().getLength() - this.bufferSize);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    private JPanel createClearPanel() {
        JPanel result = new JPanel();
        JPanel bufferSizePanel = new JPanel();
        bufferSizePanel.setLayout(new BoxLayout(bufferSizePanel, 0));
        bufferSizePanel.setBorder(BorderFactory.createTitledBorder("LogPanel settings"));
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new DocumentCleaner(this.textPane.getDocument()));
        this.autoCheck = new JCheckBox("auto", true);
        this.autoCheck.setPreferredSize(new Dimension(75, 1));
        JTextField clearText = new JTextField("" + this.bufferSize);
        clearText.setEditable(false);
        clearText.setPreferredSize(new Dimension(80, 20));
        JButton updateSize = new JButton("Change max buffer-size");
        updateSize.addActionListener(new ChangeBufferSizeListener(this, clearText));
        bufferSizePanel.add(clearButton);
        bufferSizePanel.add(this.autoCheck);
        bufferSizePanel.add(clearText);
        bufferSizePanel.add(updateSize);
        result.add((Component)bufferSizePanel, "Center");
        return result;
    }

    private Record[] constructMessage(String styledMessage) {
        String[] records = styledMessage.split("!!@@!!");
        Record[] result = new Record[records.length];
        for (int i = 0; i < records.length; ++i) {
            result[i] = this.constructRecord(records[i]);
        }
        return result;
    }

    private Record constructRecord(String styledRecord) {
        if (styledRecord.startsWith("<STYLE_DEFAULT>") && styledRecord.endsWith("</STYLE_DEFAULT>")) {
            return new Record(this.constructMessage("STYLE_DEFAULT", styledRecord), this.textPane.getStyle("STYLE_DEFAULT"));
        }
        if (styledRecord.startsWith("<STYLE_FINE>") && styledRecord.endsWith("</STYLE_FINE>")) {
            return new Record(this.constructMessage("STYLE_FINE", styledRecord), this.textPane.getStyle("STYLE_FINE"));
        }
        if (styledRecord.startsWith("<STYLE_ORIGIN>") && styledRecord.endsWith("</STYLE_ORIGIN>")) {
            return new Record(this.constructMessage("STYLE_ORIGIN", styledRecord), this.textPane.getStyle("STYLE_ORIGIN"));
        }
        if (styledRecord.startsWith("<STYLE_SOURCE>") && styledRecord.endsWith("</STYLE_SOURCE>")) {
            return new Record(this.constructMessage("STYLE_SOURCE", styledRecord), this.textPane.getStyle("STYLE_SOURCE"));
        }
        if (styledRecord.startsWith("<STYLE_WARNING>") && styledRecord.endsWith("</STYLE_WARNING>")) {
            return new Record(this.constructMessage("STYLE_WARNING", styledRecord), this.textPane.getStyle("STYLE_WARNING"));
        }
        return null;
    }

    private String constructMessage(String tag, String message) {
        return message.substring(new String("<" + tag + ">").length(), message.length() - new String("</" + tag + ">").length());
    }

    private void initializeLogger() {
        this.handler = new EventLogHandler();
        this.handler.setFormatter(new StyledTextFormatter(true));
        this.handler.addListener(this, EventLogHandler.LOG_RECORD_PRODUCED_EVENT);
        this.logger.addHandler(this.handler);
        Handler[] handlers = this.logger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            if (!(handlers[i] instanceof MemoryHandler)) continue;
            ((MemoryHandler)handlers[i]).push(this.handler);
            this.logger.removeHandler(handlers[i]);
        }
    }

    private void initializePanel() {
        this.textPane.setEditable(false);
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(500, 500));
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.textPane, 22, 30), "Center");
        JComboBox<Level> levelChooser = new JComboBox<Level>(new Level[]{Level.ALL, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.OFF});
        levelChooser.setSelectedItem(this.logger.getLevel());
        levelChooser.addActionListener(new MyLevelChooser(this.logger, levelChooser));
        this.add(levelChooser, "North");
        this.add((Component)this.createClearPanel(), "South");
        this.initStyles();
    }

    private void initStyles() {
        Style defaultStyle = this.textPane.addStyle("STYLE_DEFAULT", null);
        Style sourceStyle = this.textPane.addStyle("STYLE_SOURCE", defaultStyle);
        StyleConstants.setForeground(sourceStyle, Color.BLUE);
        Style warningStyle = this.textPane.addStyle("STYLE_WARNING", defaultStyle);
        StyleConstants.setForeground(warningStyle, Color.RED);
        Style fineStyle = this.textPane.addStyle("STYLE_FINE", defaultStyle);
        StyleConstants.setForeground(fineStyle, Color.GREEN);
        Style originStyle = this.textPane.addStyle("STYLE_ORIGIN", defaultStyle);
        StyleConstants.setForeground(originStyle, Color.GRAY);
    }

    private class Record {
        private String message;
        private Style style;

        public Record(String message, Style style) {
            this.message = message;
            this.style = style;
        }

        public String getMessage() {
            return this.message;
        }

        public Style getStyle() {
            return this.style;
        }
    }

    private class DocumentCleaner
    implements ActionListener {
        private Document document = null;

        public DocumentCleaner(Document document) {
            this.document = document;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent == null) {
                Logger.warning((Object)this, "actionPerformed", "actionEvent=null");
            }
            Document document = this.document;
            synchronized (document) {
                try {
                    this.document.remove(0, this.document.getLength());
                }
                catch (BadLocationException exception) {
                    Logger.warning((Object)this, "actionPerformed", exception);
                }
            }
        }
    }

    private class ChangeBufferSizeListener
    implements ActionListener {
        private LogPanel owner = null;
        private JTextField textField = null;

        public ChangeBufferSizeListener(LogPanel logPanel2, JTextField textField) {
            this.owner = logPanel2;
            this.textField = textField;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String result;
            if (actionEvent == null) {
                Logger.warning((Object)this, "actionPerformed", "actionEvent=null");
            }
            if ((result = JOptionPane.showInputDialog("Enter desired buffersize (integer)")) != null) {
                try {
                    int value = (int)Math.round(Double.parseDouble(result));
                    if ((double)value <= 0.0) {
                        throw new IllegalArgumentException();
                    }
                    this.owner.setBufferSize(value);
                    this.textField.setText(value + "");
                }
                catch (Exception exception) {
                    try {
                        JOptionPane.showMessageDialog(null, "Invalid input: " + result + ". value should be long and larger than 0");
                    }
                    catch (Exception remoteException) {
                        Logger.warning((Object)this, "actionPerformed", remoteException);
                    }
                }
            }
        }
    }

    private class MyLevelChooser
    implements ActionListener {
        private java.util.logging.Logger logger = null;
        private JComboBox owner = null;

        public MyLevelChooser(java.util.logging.Logger logger, JComboBox owner) {
            this.logger = logger;
            this.owner = owner;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() != null) {
                this.logger.setLevel((Level)this.owner.getSelectedItem());
            }
        }
    }
}

