/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.naming;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.spi.InitialContextFactory;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.naming.FileContext;

public class FileContextFactory
implements InitialContextFactory {
    private static FileContext context = null;

    public synchronized Context getInitialContext(Hashtable environment) {
        if (context == null) {
            try {
                URI fileURI = new URI(environment.get("java.naming.provider.url").toString());
                File file = new File(fileURI);
                if (file.exists()) {
                    ObjectInputStream stream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                    context = (FileContext)stream.readObject();
                    stream.close();
                } else {
                    context = new FileContext(file);
                }
            }
            catch (Exception exception) {
                Logger.warning((Object)this, (String)"getInitialContext", (Throwable)exception);
            }
        }
        return context;
    }
}

