/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.sne.c1;

import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.ModelInterface;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.formalisms.dess.DifferentialEquationInterface;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVDESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.statistics.Persistent;
import nl.tudelft.simulation.dsol.statistics.charts.XYChart;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.sne.c1.FCenter;

public class C1TaskC
implements ModelInterface {
    private XYChart[] chart = null;

    public void constructModel(SimulatorInterface simulator) throws RemoteException, SimRuntimeException {
        if (this.chart == null) {
            this.chart = new XYChart[3];
            this.chart[0] = new XYChart(simulator, "F-center value", 3);
            this.chart[1] = new XYChart(simulator, "R-center value", 3);
            this.chart[2] = new XYChart(simulator, "M-center value", 3);
        }
        DEVDESSSimulatorInterface dessSimulator = (DEVDESSSimulatorInterface)simulator;
        dessSimulator.setTimeStep(1.0E-5);
        FCenter fCenter = new FCenter((DESSSimulatorInterface)dessSimulator, 0.001, 4);
        this.createChart((DEVSSimulatorInterface)dessSimulator, fCenter, 0, "R");
        this.createChart((DEVSSimulatorInterface)dessSimulator, fCenter, 1, "M");
        this.createChart((DEVSSimulatorInterface)dessSimulator, fCenter, 2, "F");
    }

    private void createChart(DEVSSimulatorInterface simulator, FCenter fCenter, int index, String name) throws SimRuntimeException, RemoteException {
        AggregatingPersistent persistent = new AggregatingPersistent(name + "Value (pt=" + fCenter.getP() + ")", (SimulatorInterface)simulator);
        fCenter.addListener((EventListenerInterface)persistent, DifferentialEquationInterface.VALUE_CHANGED_EVENT[index]);
        simulator.scheduleEvent(simulator.getReplication().getRunControl().getRunLength(), (Object)this, (Object)fCenter, "removeListener", new Object[]{persistent, DifferentialEquationInterface.VALUE_CHANGED_EVENT[index]});
        this.chart[index].add((nl.tudelft.simulation.jstats.statistics.Persistent)persistent);
    }

    private class AggregatingPersistent
    extends Persistent {
        private int number = 0;

        public AggregatingPersistent(String description, SimulatorInterface simulator) throws RemoteException {
            super(description, simulator);
        }

        public void notify(EventInterface event) {
            ++this.number;
            if (event.getSource() instanceof SimulatorInterface || this.number % 1000 == 0) {
                super.notify(event);
            }
        }
    }
}

