/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.sne.c1;

import java.rmi.RemoteException;
import java.util.Properties;
import nl.tudelft.simulation.dsol.formalisms.dess.DifferentialEquation;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;

public class FCenter
extends DifferentialEquation {
    private double p = 0.0;
    private double kr = 1.0;
    private double kf = 0.1;
    private double lf = 1000.0;
    private double dr = 0.1;
    private double dm = 1.0;

    public FCenter(DESSSimulatorInterface simulator, double timeStep, short numericalMethod) throws RemoteException {
        super(simulator, timeStep, numericalMethod);
        Properties properties = this.simulator.getReplication().getRunControl().getTreatment().getProperties();
        this.kr = new Double(properties.getProperty("kr"));
        this.kf = new Double(properties.getProperty("kf"));
        this.dr = new Double(properties.getProperty("dr"));
        this.dm = new Double(properties.getProperty("dm"));
        this.lf = new Double(properties.getProperty("lf"));
        this.p = new Double(properties.getProperty("p0"));
        double t0 = new Double(properties.getProperty("t0"));
        double r0 = new Double(properties.getProperty("r0"));
        double m0 = new Double(properties.getProperty("m0"));
        double f0 = new Double(properties.getProperty("f0"));
        this.initialize(t0, new double[]{r0, m0, f0});
    }

    public double[] dy(double time, double[] y) {
        double[] dy = new double[3];
        double drr = this.dr * y[0];
        double dmm = this.dm * y[1];
        double krmf = this.kr * y[1] * y[2];
        double kfff = this.kf * Math.pow(y[2], 2.0);
        double lff = this.lf * y[2];
        dy[0] = krmf - drr;
        dy[1] = drr - dmm + kfff - krmf;
        dy[2] = drr + 2.0 * dmm - krmf - 2.0 * kfff - lff + this.p;
        return dy;
    }

    public double getLf() {
        return this.lf;
    }

    public void setLf(double lf) {
        this.lf = lf;
    }

    public double getP() {
        return this.p;
    }
}

