/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.sne.c3;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.formalisms.dess.DifferentialEquation;
import nl.tudelft.simulation.dsol.formalisms.dess.DifferentialEquationInterface;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.event.TimedEvent;

public class Amplifier
extends DifferentialEquation
implements EventListenerInterface {
    public static final EventType CURRENT_VALUE_CHANGED_EVENT = new EventType("CURRENT_VALUE_CHANGED_EVENT");
    public static final EventType VOLTAGE_VALUE_CHANGED_EVENT = new EventType("VOLTAGE_VALUE_CHANGED_EVENT");
    public static final EventType PHASE_PLANE_VALUE_CHANGED_EVENT = new EventType("PHASE_PLANE_VALUE_CHANGED_EVENT");
    private double l1 = 79.9 * Math.pow(10.0, -6.0);
    private double l3 = 232.0 * Math.pow(10.0, -6.0);
    private double c2 = 17.9 * Math.pow(10.0, -9.0);
    private double c4 = 9.66 * Math.pow(10.0, -9.0);
    private Resistor r = null;
    private double rl = 52.4;
    private double vdc = 5.0;

    public Amplifier(DESSSimulatorInterface simulator, double trf) {
        super(simulator, Math.pow(10.0, -12.0), (short)3);
        this.r = new Resistor(trf);
        this.addListener(this, DifferentialEquationInterface.VALUE_CHANGED_EVENT[1]);
        this.addListener(this, DifferentialEquationInterface.VALUE_CHANGED_EVENT[2]);
    }

    public double[] dy(double x, double[] y) {
        double[] dy = new double[]{(-y[1] + this.vdc) / this.l1, (y[0] - y[1] / this.r.getValue(x) - y[2]) / this.c2, (y[1] - this.rl * y[2] - y[3]) / this.l3, y[2] / this.c4};
        return dy;
    }

    public EigenvalueDecomposition getEigenValues(double time) {
        double[][] matrix = new double[][]{{0.0, -1.0 / this.l1, 0.0, 0.0}, {1.0 / this.c2, -1.0 / (this.c2 * this.r.getValue(time)), -1.0 / this.c2, 0.0}, {1.0 / this.l3, 0.0, -this.rl / this.l3, -1.0 / this.l3}, {0.0, 0.0, 1.0 / this.c4, 0.0}};
        return new EigenvalueDecomposition((DoubleMatrix2D)new DenseDoubleMatrix2D((double[][])matrix));
    }

    public synchronized void notify(EventInterface event) throws RemoteException {
        super.notify(event);
        if (event.getSource().equals((Object)this)) {
            double time = ((TimedEvent)event).getTimeStamp();
            if (event.getType().equals((Object)DifferentialEquationInterface.VALUE_CHANGED_EVENT[1])) {
                this.fireEvent(CURRENT_VALUE_CHANGED_EVENT, ((Number)event.getContent()).doubleValue() / this.r.getValue(time), time);
            }
            if (event.getType().equals((Object)DifferentialEquationInterface.VALUE_CHANGED_EVENT[2])) {
                this.fireEvent(VOLTAGE_VALUE_CHANGED_EVENT, ((Number)event.getContent()).doubleValue() * this.rl, time);
                this.fireEvent(PHASE_PLANE_VALUE_CHANGED_EVENT, new Double(this.dy(this.previousX, this.previousY)[2]), ((Number)event.getContent()).doubleValue());
            }
            return;
        }
    }

    public static class Resistor {
        private double on = 5.0 * Math.pow(10.0, -2.0);
        private double off = 5.0 * Math.pow(10.0, 6.0);
        private double trf = 1.0 * Math.pow(10.0, -15.0);
        private double period = 10.0 * Math.pow(10.0, -6.0);

        public Resistor() {
        }

        public Resistor(double trf) {
            this.trf = trf;
        }

        public double getValue(double time) {
            if ((time %= this.period) < this.trf) {
                return this.on + time / this.trf * (this.off - this.on);
            }
            if (time < 0.5 * this.period) {
                return this.off;
            }
            if (time < 0.5 * this.period + this.trf) {
                return this.off - (time - 0.5 * this.period) / this.trf * (this.off - this.on);
            }
            return this.on;
        }
    }
}

