/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.sne.c3;

import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.ModelInterface;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.statistics.Persistent;
import nl.tudelft.simulation.dsol.statistics.charts.XYChart;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventProducerInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.sne.c3.Amplifier;

public class C3TaskC
implements ModelInterface {
    private double[] initialValue = null;

    public void constructModel(SimulatorInterface simulator) throws SimRuntimeException, RemoteException {
        if (this.initialValue == null) {
            Amplifier amplifier = new Amplifier((DESSSimulatorInterface)simulator, 1.0E-15);
            amplifier.initialize(0.0, new double[]{0.0, 0.0, 0.0, 0.0});
            this.initialValue = amplifier.y(1.0E-4);
            System.out.println(this.initialValue[0] + " " + this.initialValue[1] + " " + this.initialValue[2] + " " + this.initialValue[3]);
        }
        double trf = new Double(simulator.getReplication().getRunControl().getTreatment().getProperties().getProperty("TRF"));
        Amplifier amplifier = new Amplifier((DESSSimulatorInterface)simulator, trf);
        amplifier.initialize(0.0, this.initialValue);
        ((DESSSimulatorInterface)simulator).setTimeStep(Math.pow(10.0, -8.0));
        XYChart xyChart = new XYChart(simulator, "IR(t) plot (TRF=" + trf + ")");
        xyChart.add((nl.tudelft.simulation.jstats.statistics.Persistent)new AggregatingPersistent("IR(t) (TRF=" + trf + ")", simulator, (EventProducerInterface)amplifier, Amplifier.CURRENT_VALUE_CHANGED_EVENT));
        xyChart = new XYChart(simulator, "VL(t) plot (TRF=" + trf + ")");
        xyChart.add((nl.tudelft.simulation.jstats.statistics.Persistent)new AggregatingPersistent("VL(t) (TRF=" + trf + ")", simulator, (EventProducerInterface)amplifier, Amplifier.VOLTAGE_VALUE_CHANGED_EVENT));
        xyChart = new XYChart(simulator, "Phase Plane plot dx3(x3) (TRF=" + trf + ")");
        xyChart.add((nl.tudelft.simulation.jstats.statistics.Persistent)new AggregatingPersistent("dX3(X3) (TRF=" + trf + ")", simulator, (EventProducerInterface)amplifier, Amplifier.PHASE_PLANE_VALUE_CHANGED_EVENT));
    }

    private class AggregatingPersistent
    extends Persistent {
        private int number = 0;

        public AggregatingPersistent(String description, SimulatorInterface simulator, EventProducerInterface target, EventType field) throws RemoteException {
            super(description, simulator, target, field);
        }

        public void notify(EventInterface event) {
            ++this.number;
            if (event.getSource() instanceof SimulatorInterface || this.number % 10 == 0) {
                super.notify(event);
            }
        }
    }
}

