/*
 * @(#) DemoModel2.java Jun 6, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic;

import java.net.URL;
import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.ModelInterface;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.traffic.file.InfraFileXMLParser;

/**
 * <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General
 * Public License (GPL) </a>, no warranty <br>
 * 
 * @version May 31, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a>
 */
public class DemoModel2 implements ModelInterface
{
    /**
     * @see nl.tudelft.simulation.dsol.ModelInterface#constructModel(nl.tudelft.simulation.dsol.simulators.SimulatorInterface)
     */
    public void constructModel(SimulatorInterface simulator)
            throws SimRuntimeException, RemoteException
    {
        try
        {
            URL url = this.getClass().getResource(
                    "/nl/tudelft/simulation/traffic/demoModel2.xml");
            System.out.println("Constructing model " + url.toString());
            new InfraFileXMLParser(url, InfraFileXMLParser.INFRAFILE_SCHEMA,
                    "http://www.simulation.tudelft.nl/traffic",
                    true, (DEVSSimulatorInterface) simulator);
        } catch (Exception e)
        {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}
