/*
 * @(#)TestTrack.java Oct 9, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic;

import java.util.List;
import nl.tudelft.simulation.traffic.track.ComplexTrackLink;
import nl.tudelft.simulation.traffic.track.SimpleTrackLink;
import nl.tudelft.simulation.traffic.track.StraightTrack;
import nl.tudelft.simulation.traffic.track.util.TrackProgression;

/**
 * <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version Oct 9, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a>
 */
public class TestTrack
{
    /**
     *  
     */
    public TestTrack()
    {
        super();
        SimpleTrackLink l1 = new SimpleTrackLink("l1", 0, 0, 0);
        SimpleTrackLink l2 = new SimpleTrackLink("l2", 100, 0, 0);
        ComplexTrackLink l3 = new ComplexTrackLink("l3", 200, 0, 0);
        SimpleTrackLink l4a = new SimpleTrackLink("l4a", 300, 0, 0);
        SimpleTrackLink l4b = new SimpleTrackLink("l4b", 300, 0, 0);
        ComplexTrackLink l5 = new ComplexTrackLink("l5", 400, 0, 0);
        SimpleTrackLink l6 = new SimpleTrackLink("l6", 500, 0, 0);
        StraightTrack t1 = new StraightTrack("t1", l1, l2);
        StraightTrack t2 = new StraightTrack("t2", l2, l3);
        StraightTrack t3a = new StraightTrack("t3a", l3, l4a);
        /* StraightTrack t3b = */new StraightTrack("t3b", l3, l4b);
        StraightTrack t4a = new StraightTrack("t4a", l4a, l5);
        /* StraightTrack t4b = */new StraightTrack("t4b", l4b, l5);
        StraightTrack t5 = new StraightTrack("t5", l5, l6);
        t2.getEndLink().setActiveSuccessor(t2, t3a);
        t4a.getEndLink().setActiveSuccessor(t4a, t5);
        System.out.println("\nFORWARD ACTIVE:");
        System.out.println("t1.active(40) = "
                + t1.calculateTrackProgressionListActive(40));
        System.out.println("t1.active(80) = "
                + t1.calculateTrackProgressionListActive(80));
        System.out.println("t1.active(99) = "
                + t1.calculateTrackProgressionListActive(99));
        System.out.println("t1.active(100) = "
                + t1.calculateTrackProgressionListActive(100));
        System.out.println("t1.active(110) = "
                + t1.calculateTrackProgressionListActive(110));
        System.out.println("t1.active(240) = "
                + t1.calculateTrackProgressionListActive(240));
        System.out.println("t1.active(340) = "
                + t1.calculateTrackProgressionListActive(340));
        System.out.println("t1.active(440) = "
                + t1.calculateTrackProgressionListActive(440));
        System.out.println("\nBACKWARD ACTIVE:");
        System.out.println("t5.active(-40) = "
                + t5.calculateTrackProgressionListActive(-40));
        System.out.println("t5.active(-80) = "
                + t5.calculateTrackProgressionListActive(-80));
        System.out.println("t5.active(-99) = "
                + t5.calculateTrackProgressionListActive(-99));
        System.out.println("t5.active(-100) = "
                + t5.calculateTrackProgressionListActive(-100));
        System.out.println("t5.active(-110) = "
                + t5.calculateTrackProgressionListActive(-110));
        System.out.println("t5.active(-240) = "
                + t5.calculateTrackProgressionListActive(-240));
        System.out.println("t5.active(-340) = "
                + t5.calculateTrackProgressionListActive(-340));
        System.out.println("t5.active(-390) = "
                + t5.calculateTrackProgressionListActive(-390));
        System.out.println("\nFORWARD ALL:");
        System.out.println("t1.All(40) = "
                + printList(t1.calculateTrackProgressionListAll(40)));
        System.out.println("t1.All(80) = "
                + printList(t1.calculateTrackProgressionListAll(80)));
        System.out.println("t1.All(99) = "
                + printList(t1.calculateTrackProgressionListAll(99)));
        System.out.println("t1.All(100) = "
                + printList(t1.calculateTrackProgressionListAll(100)));
        System.out.println("t1.All(110) = "
                + printList(t1.calculateTrackProgressionListAll(110)));
        System.out.println("t1.All(240) = "
                + printList(t1.calculateTrackProgressionListAll(240)));
        System.out.println("t1.All(340) = "
                + printList(t1.calculateTrackProgressionListAll(340)));
        System.out.println("t1.All(440) = "
                + printList(t1.calculateTrackProgressionListAll(440)));
        System.out.println("\nBACKWARD ALL:");
        System.out.println("t5.All(-40) = "
                + printList(t5.calculateTrackProgressionListAll(-40)));
        System.out.println("t5.All(-80) = "
                + printList(t5.calculateTrackProgressionListAll(-80)));
        System.out.println("t5.All(-99) = "
                + printList(t5.calculateTrackProgressionListAll(-99)));
        System.out.println("t5.All(-100) = "
                + printList(t5.calculateTrackProgressionListAll(-100)));
        System.out.println("t5.All(-110) = "
                + printList(t5.calculateTrackProgressionListAll(-110)));
        System.out.println("t5.All(-240) = "
                + printList(t5.calculateTrackProgressionListAll(-240)));
        System.out.println("t5.All(-340) = "
                + printList(t5.calculateTrackProgressionListAll(-340)));
        System.out.println("t5.All(-390) = "
                + printList(t5.calculateTrackProgressionListAll(-390)));
    }

    /**
     * @param list
     * @return
     */
    private String printList(final List list)
    {
        String s = "{";
        for (int i = 0; i < list.size(); i++)
        {
            TrackProgression tp = (TrackProgression) list.get(i);
            if (s.length() > 1)
                s = s + ", ";
            s = s + tp.toString();
        }
        s = s + "}";
        return s;
    }

    /**
     * @param args
     */
    public static void main(final String[] args)
    {
        new TestTrack();
    }
}