/*
 * Created on Nov 12, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.animation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;

import nl.tudelft.simulation.dsol.animation.D2.Renderable2D;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.traffic.track.ArcTrack;
import nl.tudelft.simulation.traffic.track.Track;

/**
 * This class is used for the animation of a curved track.
 * <p>
 * (c) copyright 2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands.
 * <p>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General
 * Public License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 June 1, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a> <br>
 * <b>Original version: </b> H.W.G. Phaff & J.H. Kwakkel
 * @see nl.tudelft.simulation.traffic.track.TrackInterface
 */
public class ArcTrackAnimation extends Renderable2D
{
    /** the dx of the track that is animated */
    private double dx;

    /** the dy of the track that is animated */
    private double dy;

    /** the track arc */
    private ArcTrack owner;

    /** the distance between the tracks of the track that is animated */
    private double width;

    /** the center x-point */
    private double cx;

    /** the center y-point */
    private double cy;

    /**
     * @param owner the owner
     * @param simulator the simulator
     * @param width
     * @throws Exception
     */
    public ArcTrackAnimation(final ArcTrack owner,
            final SimulatorInterface simulator, final double width)
            throws Exception
    {
        super(owner, simulator);
        this.dx = ((Track) super.source).getdx();
        this.dy = -((Track) super.source).getdy();
        this.owner = owner;
        this.width = width;
        this.cx = this.owner.getCenter().getX() - this.owner.getLocation().x;
        this.cy = -(this.owner.getCenter().getY() - this.owner.getLocation().y);
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.D2.Renderable2D#paint(java.awt.Graphics2D,
     * java.awt.image.ImageObserver)
     */
    public void paint(final Graphics2D gr, final ImageObserver io)
    {
        try
        {
            gr.setColor(Color.LIGHT_GRAY);
            gr.setStroke(new BasicStroke(0.05f));
            Arc2D arc = new Arc2D.Double();
            arc.setArcByCenter(this.cx, this.cy, this.owner.getRadius(), 0, 0,
                    Arc2D.PIE);
            if (this.owner.isCounterClockwise())
                arc.setAngles(0, 0, this.dx, this.dy);
            else
                arc.setAngles(this.dx, this.dy, 0, 0);
            double angleStart = arc.getAngleStart();
            double angleExtent = arc.getAngleExtent();
            if (false)
            {
                gr.draw(arc);
            }
            gr.setColor(Color.BLUE);
            gr.setStroke(new BasicStroke(0.1f));
            arc.setArcByCenter(this.cx, this.cy, this.owner.getRadius(),
                    angleStart, angleExtent, Arc2D.OPEN);
            gr.draw(arc);
            gr.setColor(Color.GREEN);
            gr.setStroke(new BasicStroke(0.1f));
            arc.setArcByCenter(this.cx, this.cy, this.owner.getRadius()
                    - this.width / 2.0, angleStart, angleExtent, Arc2D.OPEN);
            gr.draw(arc);
            arc.setArcByCenter(this.cx, this.cy, this.owner.getRadius()
                    + this.width / 2.0, angleStart, angleExtent, Arc2D.OPEN);
            gr.draw(arc);
            if (true)
            {
                arc.setArcByCenter(this.cx, this.cy, this.owner.getRadius(),
                        angleStart, angleExtent / 2.0, Arc2D.OPEN);
                Point2D half = arc.getEndPoint();
                gr.setColor(Color.BLACK);
                Font font = new Font("SansSerif", Font.PLAIN, 2)
                        .deriveFont(1.0f);
                gr.setFont(font);
                gr.drawString(this.source.toString(), (float) (half.getX()),
                        (float) (half.getY()));
            }
        } catch (Exception e)
        {
            e.printStackTrace();
        }
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.D2.Renderable2DInterface#contains(java.awt.geom.Point2D,
     * java.awt.geom.Rectangle2D, java.awt.Dimension)
     */
    public boolean contains(Point2D pointWorldCoordinates, Rectangle2D extent,
            Dimension screen)
    {
        return false;
    }
}
