/*
 * @(#)ControlPointAnimation.java Oct 31, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.animation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.animation.D2.Renderable2D;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.traffic.controlpoint.ControlPointInterface;

/**
 * This class enables the animation of a control point.
 * <p>
 * (c) copyright 2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands.
 * <p>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Oct 31, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a> <br>
 */
public class ControlPointAnimation extends Renderable2D
{
    /** the deltax of the place of the comment */
    private double deltax;

    /** the deltay of the place of the comment */
    private double deltay;

    /**
     * @param cpi
     * @param simulator
     */
    public ControlPointAnimation(final ControlPointInterface cpi,
            final SimulatorInterface simulator)
    {
        this(cpi, simulator, 0.0, 0.0);
    }

    /**
     * @param cpi
     * @param simulator
     * @param deltax
     * @param deltay
     */
    public ControlPointAnimation(final ControlPointInterface cpi,
            final SimulatorInterface simulator, final double deltax,
            final double deltay)
    {
        super(new ControlPointLocation(cpi), simulator);
        this.deltax = deltax;
        this.deltay = -deltay;
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.D2.Renderable2D#paint(java.awt.Graphics2D,
     * java.awt.image.ImageObserver)
     */
    public void paint(final Graphics2D graphics, final ImageObserver io)
            throws RemoteException
    {
        if (true)
        {
            graphics.setColor(Color.ORANGE);
            graphics.setStroke(new BasicStroke(0.05f));
            graphics.fill(new Rectangle2D.Double(-0.1, -0.1, 0.2, 0.2));
            graphics.setColor(Color.BLACK);
            Font smallFont = new Font("SansSerif", Font.PLAIN, 1);
            graphics.setFont(smallFont);
            graphics.drawString(this.source.toString(), (float) (this.deltax),
                    (float) (this.deltay));
        }
    }

}