/*
 * @(#)ControlPointLocation.java Oct 31, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.animation;

import java.rmi.RemoteException;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.traffic.controlpoint.ControlPointInterface;

/**
 * The location of a control point
 * <p>
 * (c) copyright 2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands.
 * <p>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Oct 31, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a> <br>
 */
public class ControlPointLocation implements LocatableInterface
{
    /** the location of the control point */
    private DirectedPoint location;

    /** the control point */
    private ControlPointInterface controlPoint;

    /**
     * @param cpi
     */
    public ControlPointLocation(final ControlPointInterface cpi)
    {
        this.location = cpi.getTrack().getLocationOfProgression(
                cpi.getProgression());
        this.location.setRotZ(0.0);
        this.controlPoint = cpi;
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.LocatableInterface#getBounds()
     */
    public Bounds getBounds() throws RemoteException
    {
        return new BoundingBox(new Point3d(-0.1, -0.1, 0), new Point3d(0.1,
                0.1, 0));
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.LocatableInterface#getLocation()
     */
    public DirectedPoint getLocation() throws RemoteException
    {
        return this.location;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return this.controlPoint.toString();
    }
}