/*
 * Created on Dec 18, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.animation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.animation.D2.Renderable2D;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.traffic.controlpoint.real.SpeedSign;

/**
 * This class is used for the animation of a speed sign.
 * <p>
 * (c) copyright 2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands.
 * <p>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General
 * Public License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 June 1, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a> <br>
 */
public class SpeedSignAnimation extends Renderable2D
{
    /** the deltax of the place of the traffic light */
    private double deltax;

    /** the deltay of the place of the traffic light */
    private double deltay;

    /** the background color */
    private Color backgroundColor;

    /** the text color */
    private Color textColor;

    /** the line color */
    private Color lineColor;

    /**
     * @param owner
     * @param simulator
     */
    public SpeedSignAnimation(final SpeedSign owner,
            final SimulatorInterface simulator)
    {
        this(owner, simulator, 0.0, 0.0, Color.BLACK, Color.YELLOW, Color.BLACK);
    }

    /**
     * @param owner
     * @param simulator
     * @param deltax
     * @param deltay
     * @param backgroundColor
     * @param textColor
     * @param lineColor
     */
    public SpeedSignAnimation(final SpeedSign owner,
            final SimulatorInterface simulator, final double deltax,
            final double deltay, final Color backgroundColor,
            final Color textColor, final Color lineColor)
    {
        super(owner, simulator);
        this.deltax = deltax;
        this.deltay = -deltay;
        this.backgroundColor = backgroundColor;
        this.textColor = textColor;
        this.lineColor = lineColor;
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.D2.Renderable2D#paint(java.awt.Graphics2D,
     * java.awt.image.ImageObserver)
     */
    public void paint(Graphics2D graphics, ImageObserver imo)
            throws RemoteException
    {
        SpeedSign sign = (SpeedSign) super.source;
        graphics.setColor(this.lineColor);
        graphics.setStroke(new BasicStroke(0.05f));
        graphics.draw(new Line2D.Double(0, 0, this.deltax, this.deltay));
        graphics.setColor(this.backgroundColor);
        graphics.fill(new Rectangle2D.Double(this.deltax - 3, this.deltay - 6,
                6, 6));
        graphics.setColor(this.lineColor);
        graphics.draw(new Rectangle2D.Double(this.deltax - 3, this.deltay - 6,
                6, 6));
        graphics.setColor(this.textColor);
        Font font = new Font("SansSerif", Font.PLAIN, 5);
        graphics.setFont(font);
        graphics.drawString(sign.getText(), (float) (this.deltax - 3),
                (float) (this.deltay - 1));
        if (true)
        {
            graphics.setColor(Color.BLACK);
            Font smallFont = new Font("SansSerif", Font.PLAIN, 2);
            graphics.setFont(smallFont);
            graphics.drawString(this.source.toString(),
                    (float) (this.deltax + 6), (float) (this.deltay));
        }
    }
}
