/*
 * Created on Nov 12, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.animation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;

import nl.tudelft.simulation.dsol.animation.D2.Renderable2D;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.traffic.station.Station;

/**
 * This class is used for the animation of a straight track.
 * <p>
 * (c) copyright 2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands.
 * <p>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 June 1, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a> <br>
 * <b>Original version: </b> H.W.G. Phaff & J.H. Kwakkel
 * @see nl.tudelft.simulation.traffic.track.TrackInterface
 */
public class StationAnimation extends Renderable2D
{
    /** the station */
    private Station station;

    /**
     * @param station
     * @param simulator
     */
    public StationAnimation(final Station station,
            final SimulatorInterface simulator)
    {
        super(station, simulator);
        this.station = station;
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.D2.Renderable2D#paint(java.awt.Graphics2D,
     * java.awt.image.ImageObserver)
     */
    public void paint(final Graphics2D gr, final ImageObserver io)
    {
        try
        {
            gr.setColor(Color.DARK_GRAY);
            Rectangle2D platform = new Rectangle2D.Double(0.0, -1.5d,
                    this.station.getStationLength(), 3.0d);
            gr.fill(platform);
        } catch (Exception e)
        {
            Logger.severe(this, "paint", e);
        }
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.D2.Renderable2DInterface#contains(java.awt.geom.Point2D,
     * java.awt.geom.Rectangle2D, java.awt.Dimension)
     */
    public boolean contains(Point2D pointWorldCoordinates, Rectangle2D extent,
            Dimension screen)
    {
        //return super.contains(pointWorldCoordinates, extent, screen);
        return false;
    }
}