/*
 * Created on Nov 12, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.animation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2D;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.traffic.track.Track;
import nl.tudelft.simulation.traffic.track.TrackInterface;

/**
 * This class is used for the animation of a straight track.
 * <p>
 * (c) copyright 2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands.
 * <p>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General
 * Public License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 June 1, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a> <br>
 * <b>Original version: </b> H.W.G. Phaff & J.H. Kwakkel
 * @see nl.tudelft.simulation.traffic.track.TrackInterface
 */
public class StraightTrackAnimation extends Renderable2D
{
    /** the dx of the track that is animated */
    private double dx;

    /** the dy of the track that is animated */
    private double dy;

    /** the distance betwen the tracks of the track that is animated */
    private double width;

    /**
     * @param owner the owner
     * @param simulator the simulator
     * @param width the width of the track
     */
    public StraightTrackAnimation(final TrackInterface owner,
            final SimulatorInterface simulator, final double width)
    {
        super((LocatableInterface) owner, simulator);
        this.dx = ((Track) super.source).getdx();
        this.dy = -((Track) super.source).getdy();
        this.width = width;
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.D2.Renderable2D#paint(java.awt.Graphics2D,
     * java.awt.image.ImageObserver)
     */
    public void paint(final Graphics2D gr, final ImageObserver io)
    {
        try
        {
            gr.setColor(Color.BLUE);
            gr.setStroke(new BasicStroke(0.1f));
            gr.draw(new Line2D.Double(0, 0, this.dx, this.dy));
            double alpha = Math.atan2(this.dy, this.dx);
            double wx = this.width * Math.sin(alpha) / 2.0;
            double wy = this.width * Math.cos(alpha) / 2.0;
            gr.setColor(Color.GREEN);
            gr.setStroke(new BasicStroke(0.1f));
            gr.draw(new Line2D.Double(wx, -wy, this.dx + wx, this.dy - wy));
            gr.draw(new Line2D.Double(-wx, wy, this.dx - wx, this.dy + wy));
            if (true)
            {
                double deltax = this.dx / 2;
                double deltay = this.dy / 2;
                gr.setColor(Color.BLACK);
                Font font = new Font("SansSerif", Font.PLAIN, 2)
                        .deriveFont(1.0f);
                gr.setFont(font);
                gr.drawString(this.source.toString(), (float) (deltax - 3),
                        (float) (deltay - 1));
            }
        } catch (Exception e)
        {
            e.printStackTrace();
        }
    }
    
    /**
     * @see nl.tudelft.simulation.dsol.animation.D2.Renderable2DInterface#contains(java.awt.geom.Point2D, java.awt.geom.Rectangle2D, java.awt.Dimension)
     */
    public boolean contains(Point2D pointWorldCoordinates, Rectangle2D extent,
            Dimension screen)
    {
        //return super.contains(pointWorldCoordinates, extent, screen);
        return false;
    }
}
