/*
 * Created on Dec 18, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.animation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2D;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.traffic.controlpoint.real.StopSignInterface;

/**
 * This class is used for the animation of a simple red/green traffic light.
 * <p>
 * (c) copyright 2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands.
 * <p>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General
 * Public License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 June 1, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a> <br>
 * <b>Original version: </b> H.W.G. Phaff & J.H. Kwakkel
 * @see nl.tudelft.simulation.traffic.track.TrackInterface
 */
public class TrafficLightAnimation extends Renderable2D
{
    /** the deltax of the place of the traffic light */
    private double deltax;

    /** the deltay of the place of the traffic light */
    private double deltay;

    /**
     * @param owner
     * @param simulator
     */
    public TrafficLightAnimation(final LocatableInterface owner,
            final SimulatorInterface simulator)
    {
        this(owner, simulator, 0.0, 0.0);
    }

    /**
     * @param owner
     * @param simulator
     * @param deltax
     * @param deltay
     */
    public TrafficLightAnimation(final LocatableInterface owner,
            final SimulatorInterface simulator, final double deltax,
            final double deltay)
    {
        super(owner, simulator);
        this.deltax = deltax;
        this.deltay = -deltay;
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.D2.Renderable2D#paint(java.awt.Graphics2D,
     * java.awt.image.ImageObserver)
     */
    public void paint(Graphics2D graphics, ImageObserver imo)
            throws RemoteException
    {
        StopSignInterface trafficLight = (StopSignInterface) super.source;
        graphics.setColor(Color.BLACK);
        graphics.setStroke(new BasicStroke(0.05f));
        graphics.draw(new Line2D.Double(0, 0, this.deltax, this.deltay));
        graphics.fill(new Rectangle2D.Double(this.deltax - 2, this.deltay - 8,
                4, 8));
        if (trafficLight.getStatus() == StopSignInterface.CONTINUE)
        {
            graphics.setColor(Color.GREEN);
            graphics.fill(new Ellipse2D.Double(this.deltax - 1.5,
                    this.deltay - 3.5, 3, 3));
        } else
        {
            graphics.setColor(Color.RED);
            graphics.fill(new Ellipse2D.Double(this.deltax - 1.5,
                    this.deltay - 7.5, 3, 3));
        }
        if (true)
        {
            graphics.setColor(Color.BLACK);
            Font smallFont = new Font("SansSerif", Font.PLAIN, 2);
            graphics.setFont(smallFont);
            graphics.drawString(this.source.toString(),
                    (float) (this.deltax + 4), (float) (this.deltay));
        }
    }
}
