/*
 * @(#)BlockTrafficLight.java June 6, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.animation;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2D;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

/**
 * This class animates the physical vehicle <br>
 * <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version May 31, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a>
 * 
 * @see nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface
 */
public class VehicleAnimation extends Renderable2D
        implements
            EventListenerInterface
{
    /** the physical vehicle */
    private VehiclePhysicalInterface vehiclePhysical;

    /** the color */
    private Color color;

    /**
     * constructs a new VehicleAnimation
     * 
     * @param source
     * @param simulator the simulator
     * @param color
     */
    public VehicleAnimation(final VehiclePhysicalInterface source,
            final SimulatorInterface simulator, final Color color)
    {
        super(source, simulator);
        this.vehiclePhysical = source;
        this.color = color;
        try
        {
            this.vehiclePhysical.addListener(this,
                    VehiclePhysicalInterface.REMOVE_EVENT);
        } catch (RemoteException e)
        {
            e.printStackTrace();
        }
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.D2.Renderable2D#paint(java.awt.Graphics2D,
     * java.awt.image.ImageObserver)
     */
    public void paint(final Graphics2D gr, final ImageObserver imo)
    {
        if (this.vehiclePhysical == null)
            return;
        double length = this.vehiclePhysical.getVehicleType().getLength();
        double width = this.vehiclePhysical.getVehicleType().getWidth();
        gr.setColor(this.color);
        gr.fill(new Rectangle2D.Double(0.0, (-width / 2.0d), length, width));
    }

    /**
     * @see nl.tudelft.simulation.event.EventListenerInterface#notify(nl.tudelft.simulation.event.EventInterface)
     */
    public void notify(EventInterface event) throws RemoteException
    {
        if (event.getType().equals(VehiclePhysicalInterface.REMOVE_EVENT))
        {
            super.destroy();
            this.vehiclePhysical = null;
        }
    }
}