/*
 * Created on Dec 4, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.controlpoint;

import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

/**
 * The ControlPointInterface defines the interface of controlpoints. By
 * definition a controlpoint is a point on a track where something is happening
 * that is relevant for a vehicle. A controlpoint enables the exchange of
 * information between a vehicle and the infrastructure. <br>
 * <br>
 */
public interface ControlPointInterface extends LocatableInterface
{
    /** a trigger of the controlpoint with the front of the vehicle */
    public static final String FRONT = "FRONT";

    /** a trigger of the controlpoint with the back of the vehicle */
    public static final String BACK = "BACK";

    /**
     * This method returns the track on which the controlPoint is located
     * 
     * @return track
     */
    public TrackInterface getTrack();

    /**
     * The getProgression() method returns progression where the controlPoint is
     * located
     * 
     * @return progression
     */
    public double getProgression();

    /**
     * This method handles actions of the controlPoint when the controlPoint is
     * passed by a vehicle.
     * 
     * @param vehicle that triggers the controlPoint
     */
    public void pass(VehiclePhysicalInterface vehicle);
}