/*
 * @(#)BlockControlPoint.java May 31, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.controlpoint.blocks;

import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.traffic.controlpoint.virtual.VirtualControlPoint;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

/**
 * This class implements red, yellow and green virtual control points for the
 * BlockTrafficLights <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version May 31, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a>
 */
public class BlockControlPoint extends VirtualControlPoint
{
    /** object to call when sensor is triggered */
    private BlockTrafficLight callBack;

    /** which sensor is this? */
    private int sensor;

    /**
     * @param track
     * @param progression
     * @param callBack
     * @param sensor
     * @param simulator
     */
    public BlockControlPoint(final TrackInterface track,
            final double progression, final BlockTrafficLight callBack,
            final int sensor, final SimulatorInterface simulator)
    {
        super(track, progression, simulator);
        this.callBack = callBack;
        this.sensor = sensor;
    }

    /**
     * @see nl.tudelft.simulation.traffic.controlpoint.ControlPointInterface#pass(nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface)
     */
    public void pass(final VehiclePhysicalInterface vehicle)
    {
        this.callBack.triggerSensor(this.sensor, vehicle);
    }
}