/*
 * @(#)SwitchVirtualBlock.java Jun 20, 2004
 * 
 * Copyright (c) 2004 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.controlpoint.blocks;

import java.util.HashMap;
import java.util.Map;

/**
 * Th SwitchVirtualBlock defines the block to be guarded.
 * <p>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version Jun 20, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a>
 */
public class SwitchVirtualBlock extends VirtualBlock
{
    /** the directions contained in the virtual block * */
    private Map directions = new HashMap();

    /**
     * constucts a new SwitchVirtualBlock
     * 
     * @param name the name of the SwitchVirtualBlock
     */
    public SwitchVirtualBlock(String name)
    {
        super(name);
    }

    /**
     * adds a direction to the block
     * 
     * @param trafficLight
     * @param line
     * @param complexLink
     * @param track
     */
    public void addSwitchDirection(final SwitchBlockTrafficLight trafficLight,
            final int line, final String complexLink, final String track)
    {
        Record record = new Record(trafficLight, line, complexLink, track);
        this.directions.put(trafficLight.toString() + "@" + line, record);
    }

    /**
     * An innerclass containing the record.
     */
    private static class Record
    {
        /** the traficLight * */
        private SwitchBlockTrafficLight trafficLight = null;

        /** the line */
        private int line;

        /** the complexLine */
        private String complexLine = null;

        /** the track */
        private String track = null;

        /**
         * construct a new Record
         * 
         * @param trafficLight the trafficLight
         * @param line the line
         * @param complexLine the complexLine
         * @param track the track
         */
        public Record(SwitchBlockTrafficLight trafficLight, int line,
                String complexLine, String track)
        {
            super();
            this.trafficLight = trafficLight;
            this.line = line;
            this.complexLine = complexLine;
            this.track = track;
        }

        /**
         * @return Returns the complexLine.
         */
        public String getComplexLine()
        {
            return this.complexLine;
        }

        /**
         * @return Returns the line.
         */
        public int getLine()
        {
            return this.line;
        }

        /**
         * @return Returns the track.
         */
        public String getTrack()
        {
            return this.track;
        }

        /**
         * @return Returns the trafficLight.
         */
        public SwitchBlockTrafficLight getTrafficLight()
        {
            return this.trafficLight;
        }
    }
}