/*
 * Created on Jun 25, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.controlpoint.blocks;

import java.util.ArrayList;

/**
 * This class implements a virtual block that will be guarded by n
 * SingleTrackBlockTrafficLights. Only one vehicle is allowed in the Block.
 * <p>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General
 * Public License (GPL) </a>, no warranty <br>
 * 
 * @version Jun 20, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a>
*/
public class VirtualBlock
{
    /** busy shows the number of vehicles in the guarded block */
    protected int busy;

    /**
     * requestList shows the list of SwicthBlockTrafficLights that are
     * requesting access to the block
     */
    public ArrayList requestList;

    /** name of the guarded block */
    private String name;

    /**
     * Constructs a VirtualBlock
     * 
     * @param name name of the VirtualBlock
     */
    public VirtualBlock(final String name)
    {
        this.name = name;
        this.busy = 0;
        this.requestList = new ArrayList();
    }

    /**
     * requestAccess process the request to gain access to the block
     * 
     * @param switchBlockTrafficLight the correpondent switchBlockTrafficLight
     * that want to gain access to the block
     */
    public void requestAccess(
            final SwitchBlockTrafficLight switchBlockTrafficLight)
    {
        System.out.println("Access to Virtual Block " + this.name
                + " has been requested");
        if (this.busy == 0)
        {
            this.busy++;
            switchBlockTrafficLight
                    .changeState(SwitchBlockTrafficLight.STATE_GREEN);
        } else
        {
            this.requestList.add(switchBlockTrafficLight);
        }
    }

    /**
     * releaseBlock releases the block for other vehicles and check if there is
     * any access request in the requesList
     */
    public void releaseBlock()
    {
        System.out.println("Virtual Block " + this.name + " has been released");
        this.busy--;
        if (!this.requestList.isEmpty())
        {
            SwitchBlockTrafficLight switchBlockTrafficLight = (SwitchBlockTrafficLight) (this.requestList
                    .remove(0));
            requestAccess(switchBlockTrafficLight);
        }
    }

    /**
     * @return Returns the name.
     */
    public String getName()
    {
        return this.name;
    }
}