/*
 * Created on Mar 29, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.controlpoint.real;

import nl.tudelft.simulation.event.EventType;

/**
 * This interface is used by controlPoints that can change their status like a
 * trafficlight <br>
 * 
 * @author H.W.G. Phaff & J.H. Kwakkel
 */
public interface Changeable
{
    /**
     * This event signals that the status a real controlPoint has changed
     */
    public static final EventType CHANGE_STATUS_EVENT = new EventType(
            "CHANGE_STATUS_EVENT");

    /**
     * @return status
     */
    public String getStatus();
}
