/*
 * @(#)RemoveControlPoint.java Jun 21, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.controlpoint.real;

import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.traffic.controlpoint.virtual.VirtualControlPoint;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

/**
 * <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version Jun 21, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a>
 */
public class RemoveControlPoint extends VirtualControlPoint
{
    /**
     * @param track
     * @param progression
     * @param simulator
     */
    public RemoveControlPoint(final TrackInterface track,
            final double progression, final SimulatorInterface simulator)
    {
        super(track, progression, simulator);
        System.out.println("removeControlpoint added on track " + track);
    }

    /**
     * @see nl.tudelft.simulation.traffic.controlpoint.ControlPointInterface#pass(nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface)
     */
    public void pass(VehiclePhysicalInterface vehicle)
    {
        try
        {
            System.out.println("removeControlpoint track " + super.getTrack()
                    + ", remove vehicle " + vehicle);
            vehicle.removeVehicle();
        } catch (RemoteException e)
        {
            e.printStackTrace();
        }
    }
}