/*
 * Created on 29-dec-2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.controlpoint.real;

import java.awt.Color;
import java.rmi.RemoteException;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.traffic.animation.SpeedSignAnimation;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

/**
 * This class represents a simple sign. Basically it only implements the
 * SpeedLimitInterface and extends the AbstractVisibleControlPoint. <br>
 * <br>
 * 
 * @author J.H. Kwakkel & H.W.G. Phaff
 * 
 * @see nl.tudelft.simulation.traffic.controlpoint.real.SpeedLimitInterface
 * @see nl.tudelft.simulation.traffic.controlpoint.real.AbstractVisibleControlPoint
 */
public class SpeedSign extends AbstractVisibleControlPoint
        implements
            SpeedLimitInterface,
            LocatableInterface
{
    /** the speed limit */
    private double speedLimit;

    /** the name */
    private String name;

    /** dx for animation (bounds) */
    private double dx;

    /** dy for animation (bounds) */
    private double dy;

    /** the text to display */
    private String text;

    /**
     * @param name
     * @param track
     * @param progression
     * @param visibleDistance
     * @param speedLimit
     * @param simulator
     * @param dx
     * @param dy
     * @param text
     * @param backgroundColor
     * @param textColor
     * @param lineColor
     */
    public SpeedSign(final String name, final TrackInterface track,
            final double progression, final double visibleDistance,
            final double speedLimit, final SimulatorInterface simulator,
            final double dx, final double dy, final String text,
            final Color backgroundColor, final Color textColor,
            final Color lineColor)
    {
        super(track, progression, visibleDistance, simulator);
        this.name = name;
        System.out.println(this + ", placed on " + track + " progression "
                + progression + " (length=" + track.getLength() + ")");
        this.speedLimit = speedLimit;
        this.dx = dx;
        this.dy = dy;
        this.text = text;
        if (simulator instanceof AnimatorInterface)
        {
            new SpeedSignAnimation(this, simulator, dx, dy, backgroundColor,
                    textColor, lineColor);
        }
    }

    /**
     * @see nl.tudelft.simulation.traffic.controlpoint.ControlPointInterface#pass(nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface)
     */
    public void pass(VehiclePhysicalInterface vehicle)
    {
        vehicle.setMaximumSpeed(this.speedLimit);
    }

    /**
     * @see nl.tudelft.simulation.traffic.controlpoint.ControlPointInterface#getProgression()
     */
    public double getProgression()
    {
        return super.getProgression();
    }

    /**
     * @see nl.tudelft.simulation.traffic.controlpoint.ControlPointInterface#getTrack()
     */
    public TrackInterface getTrack()
    {
        return super.getTrack();
    }

    /**
     * @see nl.tudelft.simulation.traffic.controlpoint.real.SpeedLimitInterface#getSpeedLimit()
     */
    public double getSpeedLimit()
    {
        return this.speedLimit;
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.LocatableInterface#getLocation()
     */
    public DirectedPoint getLocation() throws RemoteException
    {
        DirectedPoint p = super.getTrack().getLocationOfProgression(
                super.getProgression());
        return new DirectedPoint(p.x, p.y, p.z);
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.LocatableInterface#getBounds()
     */
    public Bounds getBounds() throws RemoteException
    {
        return new BoundingBox(new Point3d(this.dx - 3.0, this.dy, 0),
                new Point3d(this.dx + 3.0, this.dy + 6.0, 0));
    }

    /**
     * @return Returns the display text.
     */
    public String getText()
    {
        return this.text;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "Speedsign " + this.name;
    }
}