/*
 * Created on Dec 17, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.controlpoint.real;

import nl.tudelft.simulation.traffic.controlpoint.ControlPointInterface;

/**
 * This interface is used to signify that the implementing class can be seen by
 * the VehicleControl. A vehicleControl bases his behavior on the objects it can
 * see. The only objects a vehicleControl can see, are instances of a class that
 * implements the VisibleControlPointInterface. If a class does not implement
 * this interface, then it won't be seen by a vehicleControl, hence a
 * vehicleControl will not base it's behavior on it. <br>
 */
public interface VisibleControlPointInterface extends ControlPointInterface
{
    /**
     * The visibleDistance parameter defines the distance from which the
     * ControlPoint becomes visible. This distance is defined along the
     * infrastructure, in the opposite direction for which the visible defines a
     * rule.
     * 
     * @return the visible distance
     */
    public double getVisibleDistance();
}