/*
 * Created on Dec 19, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.controlpoint.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

import nl.tudelft.simulation.traffic.controlpoint.ControlPointInterface;

/**
 * This class implements a list containing controlPoints. It is an sorted set
 * that can only be used for controlPoints.
 * 
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a> <br>
 */
public class ControlPointsList
{
    /** the list of control points */
    private SortedSet list = new TreeSet(new ProgressionComparator());

    /**
     * Add a control point
     * 
     * @param cp control point to add
     */
    public void add(final ControlPointInterface cp)
    {
        this.list.add(cp);
    }

    /**
     * Does the control point list contain a certain control point?
     * 
     * @param cp
     * @return boolean
     */
    public boolean contains(final ControlPointInterface cp)
    {
        return this.list.contains(cp);
    }

    /**
     * @param cp
     */
    public void remove(final ControlPointInterface cp)
    {
        this.list.remove(cp);
    }

    /**
     * @return size
     */
    public int size()
    {
        return this.list.size();
    }

    /**
     * @return Iterator
     */
    public Iterator iterator()
    {
        return this.list.iterator();
    }

    /**
     * @return boolean
     */
    public boolean isEmpty()
    {
        return this.list.isEmpty();
    }

    /**
     * This method clears the entire list
     */
    public void clear()
    {
        this.list.clear();
    }

    /**
     * @param cpl
     */
    public void addAll(final ControlPointsList cpl)
    {
        this.list.addAll(cpl.getList());
    }

    /**
     * @return set
     */
    public SortedSet getList()
    {
        return this.list;
    }

    /**
     * @return cloned list
     */
    public ControlPointsList cloneList()
    {
        ControlPointsList clone = new ControlPointsList();
        clone.addAll(this);
        return clone;
    }

    /**
     * @param removeList
     */
    public void removeAll(final ControlPointsList removeList)
    {
        this.list.removeAll(removeList.getList());
    }
    
    /**
     * @return first control point in this list
     */
    public ControlPointInterface first()
    {
        return (ControlPointInterface) this.list.first();
    }

    /**
     * Inner class ProgressionComparator. Makes sure that the control points
     * are sorted on their progression along the Track. <br>
     * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
     * University of Technology </a>, the Netherlands. <br>
     * See for project information <a href="http://www.simulation.tudelft.nl">
     * www.simulation.tudelft.nl </a> <br>
     * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General
     * Public License (GPL) </a>, no warranty <br>
     * 
     * @version Jun 19, 2004 <br>
     * @author <a
     * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
     * Verbraeck </a>
     */
    private class ProgressionComparator implements Comparator
    {
        /**
         * @see java.util.Comparator#compare(java.lang.Object,
         * java.lang.Object)
         */
        public int compare(final Object arg0, final Object arg1)
        {
            ControlPointInterface cp0 = (ControlPointInterface) arg0;
            ControlPointInterface cp1 = (ControlPointInterface) arg1;
            if (cp0.getProgression() < cp1.getProgression())
                return -1;
            if (cp0.getProgression() > cp1.getProgression())
                return 1;
            if (cp0.hashCode() < cp1.hashCode())
                return -1;
            if (cp0.hashCode() > cp1.hashCode())
                return 1;
            return 0; // probably really the same control points
        }
    }
}
