/*
 * Created on Dec 18, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.controlpoint.virtual;

import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.traffic.controlpoint.real.VisibleControlPointInterface;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

/**
 */
public class Show extends VirtualControlPoint implements ShowInterface
{
    /** the owner */
    private VisibleControlPointInterface owner;

    /**
     * @param track
     * @param progression
     * @param owner
     * @param simulator
     */
    public Show(final TrackInterface track, final double progression,
            final VisibleControlPointInterface owner,
            final SimulatorInterface simulator)
    {
        super(track, progression, simulator);
        this.owner = owner;
    }

    /**
     * @see nl.tudelft.simulation.traffic.controlpoint.virtual.ShowInterface#getOwner()
     */
    public VisibleControlPointInterface getOwner()
    {
        return this.owner;
    }

    /**
     * @see nl.tudelft.simulation.traffic.controlpoint.ControlPointInterface#pass(nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface)
     */
    public void pass(final VehiclePhysicalInterface vehicle)
    {
        EventInterface ev = new Event(ShowInterface.VISIBLE, this, this.owner);
        this.fireEvent(ev);
    }
}