/*
 * Created on Dec 18, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.controlpoint.virtual;

import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.traffic.controlpoint.real.VisibleControlPointInterface;

/**
 * This interface defines the behavior of show classes. A show is a controlPoint
 * which makes makes the visibleControlPoint associated with this show (the
 * owner) visible to the vehicle that passes the show. The owner has one and
 * only one show for each and every path along which it can be reached. <br>
 * <br>
 * 
 * @author J.H. Kwakkel & H.W.G. Phaff
 */
public interface ShowInterface extends VirtualControlPointInterface
{
    /**
     * This event signals the owner becoming visible. It is fired when a vehicle
     * passes over this controlPoint.
     */
    public static final EventType VISIBLE = new EventType("Show.VISIBLE");

    /**
     * Returns the ControlPointInterface to be made visible
     * 
     * @return Owner, the visibleControlPoint to
     */
    public VisibleControlPointInterface getOwner();
}