/*
 * Created on Dec 4, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.controlpoint.virtual;

import java.rmi.RemoteException;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.traffic.animation.ControlPointAnimation;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.track.util.TrackProgression;

/**
 */
public abstract class VirtualControlPoint extends EventProducer
        implements
            VirtualControlPointInterface
{
    /** location of the control point in terms of progression */
    private double progression;

    /** track on which the control point lies */
    private TrackInterface track;

    /** the location of the control point */
    private DirectedPoint location;

    /**
     * @param track
     * @param progression
     * @param simulator
     */
    public VirtualControlPoint(final TrackInterface track,
            final double progression, final SimulatorInterface simulator)
    {
        TrackProgression tp = track
                .calculateTrackProgressionListActive(progression);
        this.track = tp.getTrack();
        this.progression = tp.getProgression();
        this.location = this.track.getLocationOfProgression(this.progression);
        this.location.setRotZ(0.0);
        this.track.addControlPoint(this);
        // create animation
        if (simulator instanceof AnimatorInterface)
        {
            new ControlPointAnimation(this, simulator);
        }
    }

    /**
     * @see nl.tudelft.simulation.traffic.controlpoint.ControlPointInterface#getProgression()
     */
    public double getProgression()
    {
        return this.progression;
    }

    /**
     * @see nl.tudelft.simulation.traffic.controlpoint.ControlPointInterface#getTrack()
     */
    public TrackInterface getTrack()
    {
        return this.track;
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.LocatableInterface#getBounds()
     */
    public Bounds getBounds() throws RemoteException
    {
        return new BoundingBox(new Point3d(-0.1, -0.1, 0), new Point3d(0.1,
                0.1, 0));
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.LocatableInterface#getLocation()
     */
    public DirectedPoint getLocation() throws RemoteException
    {
        return this.location;
    }
}