/*
 * Created on Aug 20, 2004
 * 
 * (c) copyright 2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br> See for project
 * information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br> License of use: <a
 * href="http://www.gnu.org/copyleft/gpl.html">General Public License (GPL)
 * </a>, no warranty <br>
 * 
 * @version May 31, 2004 <br> @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/elisangelak/index.htm">Elisangela
 * Mieko Kanacilo * </a>
 */

package nl.tudelft.simulation.traffic.station;

import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.traffic.controlpoint.blocks.BlockTrafficLight;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

/*
 * Created on Sep 28, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
/**
 * <br>
 * This class is the implementation of a stopping place. Each station is divided
 * into stopping places and the number varies accordingly to its length
 * 
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version Aug 20, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/elisangelak/index.htm">Elisangela
 * Kanacilo </a>
 */
public class StoppingPlace
{
    /** point where the vehicle is allowed to stop */
    private double progression;

    /** length of the stoppingPlace */
    private double length;

    /** controls the availability of the stopping place */
    private boolean claimed = false;

    /** stationTrack to which the stopping place belong */
    private Station station;

    /** track on where the stopping place starts */
    private TrackInterface startTrack;

    /** object to call when sensor is triggered */
    private BlockTrafficLight callBack;

    /** object to call when sensor is triggered */
    private int sensor;

    /** simulator for the virtual BlockTrafficLight */
    //   private DEVSSimulatorInterface simulator;
    /**
     * @param station station to where it belongs
     * @param track starting track of the stopping place
     * @param progression position related to the track where the stoppingPlace
     * starts
     * @param requestDistance
     * @param length length of the stopping place
     * @param simulator
     */
    public StoppingPlace(final Station station, final TrackInterface track,
            final double progression, final double requestDistance,
            final double length, final DEVSSimulatorInterface simulator)
    {
        this.station = station;
        this.startTrack = track;
        this.progression = progression;
        this.length = length;
        new StationHaltingTrafficLight(this.station, this.station.getName(),
                this.startTrack, this.progression, requestDistance + 5.0,
                requestDistance, simulator, 0, 10);
    }

    /**
     * @return
     */
    public boolean claimStoppingPlace()
    {
        if (this.claimed)
            return false;
        this.setClaimed(true);
        return true;
    }

    /** make the stopping place available */
    public void releaseStoppingPlace()
    {
        if (!this.isClaimed())
            System.out.print("WARNING: stopping place of the progression"
                    + this.getProgression() + " is already available");
        else
        {
            this.setClaimed(false);
            System.out.print("stopping place of progression" + this.progression
                    + " is now set as available");
        }
    }

    /**
     * (non-Javadoc)
     * 
     * @param vehicle
     * 
     * @see nl.tudelft.simulation.traffic.controlpoint.ControlPointInterface#pass(nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface)
     */
    public void pass(final VehiclePhysicalInterface vehicle)
    {
        this.callBack.triggerSensor(this.sensor, vehicle);
        this.setClaimed(false);
    }

    /**
     * @return Returns the stationTrack.
     */
    public Station getStation()
    {
        return this.station;
    }

    /**
     * check if the place was already claimed
     * 
     * @return
     */
    public boolean isClaimed()
    {
        return this.claimed;
    }

    /**
     * @return Returns the length.
     */
    public double getLength()
    {
        return this.length;
    }

    /**
     * @return Returns the progression.
     */
    public double getProgression()
    {
        return this.progression;
    }

    /**
     * @param claimed The claimed to set.
     */
    public void setClaimed(boolean claimed)
    {
        this.claimed = claimed;
    }

    /**
     * @return Returns the startTrack.
     */
    public TrackInterface getStartTrack()
    {
        return this.startTrack;
    }
}