/*
 * @(#)StraightTrack.java May 30, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.track;

import java.rmi.RemoteException;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;

/**
 * A straight track from one link to another link. <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version May 30, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a> <br>
 * 
 * Original authors: J.H. Kwakkel and H.W.G. Phaff
 */
public class StraightTrack extends Track
{
    /** the angle of the straight track */
    private double theta = 0.0;

    /** the length of the track */
    private double length;

    /**
     * @param name
     * @param startLink
     * @param endLink
     */
    public StraightTrack(final String name, TrackLinkInterface startLink,
            TrackLinkInterface endLink)
    {
        super(name, startLink, endLink);
        try
        {
            this.length = this.startLink.getLocation().distance(
                    this.endLink.getLocation());
        } catch (RemoteException exception)
        {
            exception.printStackTrace();
        }
        this.theta = Math.atan2(super.getdy(), super.getdx());
    }

    /**
     * @see nl.tudelft.simulation.traffic.track.TrackInterface#getLocationOfProgression(double)
     */
    public DirectedPoint getLocationOfProgression(final double progression)
    {
        double delta = progression / this.length;
        Point3d startPoint = this.startLink.getPosition();
        Point3d endPoint = this.endLink.getPosition();
        double x = startPoint.x + delta * (endPoint.x - startPoint.x);
        double y = startPoint.y + delta * (endPoint.y - startPoint.y);
        double z = startPoint.z + delta * (endPoint.z - startPoint.z);
        return new DirectedPoint(x, y, z, 0.0, 0.0, this.theta);
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.LocatableInterface#getBounds()
     */
    public Bounds getBounds()
    {
        Point3d p = this.startLink.getPosition();
        Point3d q = this.endLink.getPosition();
        return new BoundingBox(new Point3d(0, 0, 0), new Point3d(q.x - p.x, q.y
                - p.y, q.z - p.z));
    }

    /**
     * @see nl.tudelft.simulation.traffic.track.TrackInterface#getLength()
     */
    public double getLength()
    {
        return this.length;
    }
}