/*
 * Created on Dec 15, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.track;

import javax.vecmath.Point3d;

import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.traffic.track.util.TrackList;

/**
 * This interface defines the interface of TrackLinks. A link is used for
 * connections between tracks. <br>
 * <br>
 * Tracks need to be explicitly added to links. The possibility to travel
 * from track A to track B has to be explicitly defined using the
 * addSuccessorToTrack() method. A connection between tracks is only
 * possible between tracks added to the link. <br>
 * <br>
 * A simpleTrackLink is a location. <br>
 * <br>
 * 
 * @see nl.tudelft.simulation.traffic.track.TrackInterface
 * 
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a> <br>
 */
public interface TrackLinkInterface extends LocatableInterface
{
    /**
     * Adds a successor to this link.
     * 
     * @param successor
     */
    public void addSuccessor(final TrackInterface successor);

    /**
     * Adds a predecessor to this link.
     * 
     * @param predecessor
     */
    public void addPredecessor(final TrackInterface predecessor);

    /**
     * This method sets the active successor of the given track.
     * 
     * @param predecessor
     * @param successor
     */
    public void setActiveSuccessor(final TrackInterface predecessor,
            final TrackInterface successor);

    /**
     * This method gets the active successor of the given track.
     * 
     * @param predecessor
     * @return activeSuccessor
     */
    public TrackInterface getActiveSuccessor(final TrackInterface predecessor);

    /**
     * Returns all successors for this link.
     * 
     * @return successors
     */
    public TrackList getSuccessors();

    /**
     * Returns all predecessors for this link.
     * 
     * @return TrackList
     */
    public TrackList getPredecessors();

    /**
     * @return position
     */
    public Point3d getPosition();
}