/*
 * @(#)StraightTrack.java May 30, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.track;

import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;

import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;

/**
 * A virtual track for deleting vehicles at the end of the studied track. <br>
 * <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version May 30, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a> <br>
 */
public class VirtualTrack extends Track
{
    /**
     * @param name
     * @param startLink
     * @param endLink
     * @throws Exception
     */
    public VirtualTrack(final String name, TrackLinkInterface startLink,
            TrackLinkInterface endLink) throws Exception
    {
        super(name, startLink, endLink);
    }

    /**
     * @see nl.tudelft.simulation.traffic.track.TrackInterface#getLocationOfProgression(double)
     */
    public DirectedPoint getLocationOfProgression(final double progression)
    {
        double delta = progression / 1000.0;
        Point3d startPoint = this.startLink.getPosition();
        Point3d endPoint = this.endLink.getPosition();
        double x = startPoint.x + delta * (endPoint.x - startPoint.x);
        double y = startPoint.y + delta * (endPoint.y - startPoint.y);
        double z = startPoint.z + delta * (endPoint.z - startPoint.z);
        return new DirectedPoint(x, y, z, 0.0, 0.0, 0.0);
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.LocatableInterface#getBounds()
     */
    public Bounds getBounds()
    {
        return new BoundingBox();
    }

    /**
     * @see nl.tudelft.simulation.traffic.track.TrackInterface#getLength()
     */
    public double getLength()
    {
        return 1000.0;
    }
}