/*
 * Created on Dec 19, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.track.util;

import java.util.ArrayList;
import java.util.Iterator;

import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.traffic.track.TrackInterface;

/**
 * This class functions as an ArrayList holding only tracks.
 * 
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a> <br>
 */
public class TrackList
{
    /** list of tracks */
    private ArrayList list;

    /**
     * Constructor of the list
     */
    public TrackList()
    {
        this.list = new ArrayList();
    }

    /**
     * @param track
     */
    public void add(final TrackInterface track)
    {
        if (this.list.contains(track))
        {
            Logger.warning(this, "add", "track "+track+" already in track list");
            //new Exception("track "+track+" already in track list").printStackTrace();
        }
        else
            this.list.add(track);
    }

    /**
     * @param track
     * @return boolean
     */
    public boolean contains(final TrackInterface track)
    {
        return this.list.contains(track);
    }

    /**
     * @param i
     * @return track
     */
    public TrackInterface get(final int i)
    {
        return (TrackInterface) this.list.get(i);
    }

    /**
     * @param track
     * @return boolean
     */
    public boolean equals(final TrackInterface track)
    {
        return this.list.equals(track);
    }

    /**
     * @param track
     * @return index
     */
    public int indexOf(final TrackInterface track)
    {
        return this.list.indexOf(track);
    }

    /**
     * @param track
     */
    public void remove(final TrackInterface track)
    {
        this.list.remove(track);
    }

    /**
     * @param i
     */
    public void remove(final int i)
    {
        this.list.remove(i);
    }

    /**
     * @return size
     */
    public int size()
    {
        return this.list.size();
    }

    /**
     * @return
     */
    public Iterator iterator()
    {
        return this.list.iterator();
    }

    /**
     * @return
     */
    public TrackList cloneList()
    {
        TrackList slist = new TrackList();
        slist.list = (ArrayList) this.list.clone();
        return slist;
    }

    /**
     * @return
     */
    public TrackInterface[] toArray()
    {
        Object[] objs = this.list.toArray();
        TrackInterface[] tracks = new TrackInterface[objs.length];
        for (int i = 0; i < tracks.length; i++)
        {
            tracks[i] = (TrackInterface) objs[i];
        }
        return tracks;
    }
}