/*
 * @(#)TrackProgression.java Oct 4, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.track.util;

import nl.tudelft.simulation.traffic.track.TrackInterface;

/**
 * <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version Oct 4, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a>
 */
public class TrackProgression
{
    /** the track */
    private TrackInterface track;

    /** the progression */
    private double progression;

    /**
     * @param track
     * @param progression
     *  
     */
    public TrackProgression(final TrackInterface track, final double progression)
    {
        super();
        this.track = track;
        this.progression = progression;
    }

    /**
     * @return Returns the progression.
     */
    public double getProgression()
    {
        return this.progression;
    }

    /**
     * @return Returns the track.
     */
    public TrackInterface getTrack()
    {
        return this.track;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return this.track + "[" + this.progression + "]";
    }
}