/*
 * @(#)VehicleControl.java Jul 4, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.vehicle;

import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.simulators.DEVDESSSimulatorInterface;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.traffic.track.TrackInterface;

/**
 * <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version Jul 4, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a>
 */
public class VehicleControl extends EventProducer
        implements
            VehicleControlInterface
{
    /** the physical vehicle */
    private VehiclePhysicalInterface vehiclePhysical;

    /** the line id */
    private String line;

    /**
     * @param line
     *  
     */
    public VehicleControl(final String line)
    {
        this.line = line;
    }

    /**
     * @param track
     * @param progression
     * @param maxSpeedStart
     * @param simulator
     * @param vehicleType
     * @param line
     * @throws Exception
     */
    public VehicleControl(final TrackInterface track, final double progression,
            final double maxSpeedStart,
            final DEVDESSSimulatorInterface simulator,
            final VehicleType vehicleType, final String line) throws Exception
    {
        this.line = line;
        this.vehiclePhysical = new VehiclePhysical(vehicleType, this, track,
                progression, maxSpeedStart, simulator);
    }

    /**
     * @see nl.tudelft.simulation.traffic.vehicle.VehicleControlInterface#startDriving()
     */
    public void startDriving()
    {
        this.vehiclePhysical.startDriving();
    }

    /**
     * @see nl.tudelft.simulation.traffic.vehicle.VehicleControlInterface#getVehiclePhysical()
     */
    public VehiclePhysicalInterface getVehiclePhysical()
    {
        return this.vehiclePhysical;
    }

    /**
     * @see nl.tudelft.simulation.traffic.vehicle.VehicleControlInterface#setVehiclePhysical(nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface)
     */
    public synchronized void setVehiclePhysical(
            VehiclePhysicalInterface vehiclePhysical) throws Exception
    {
        this.vehiclePhysical = vehiclePhysical;
    }

    /**
     * @return Returns the line.
     */
    public String getLine()
    {
        return this.line;
    }

    /**
     * @see nl.tudelft.simulation.traffic.vehicle.VehicleControlInterface#removeVehicle()
     */
    public void removeVehicle() throws RemoteException
    {
        //
    }

    /**
     * @see nl.tudelft.simulation.event.EventListenerInterface#notify(nl.tudelft.simulation.event.EventInterface)
     */
    public void notify(EventInterface event) throws RemoteException
    {
        //
    }
}