/*
 * Created on Jun 25, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.vehicle;

import java.rmi.RemoteException;

import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.EventProducerInterface;
import nl.tudelft.simulation.event.EventType;

/**
 * This interface defines the behavior of the control of a vehicle. The control
 * takes the decisions regarding the behavior of the vehicle based on the
 * environment and its own internal parameters. For instance, it decides when
 * and if to stop for trafficlights or adapt to speedlimits. <br>
 * <br>
 * For a detailed discussion of the involved logic, see the report (hyperlink?)
 * and the source code of the implementation classes.
 * <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General
 * Public License (GPL) </a>, no warranty <br>
 * 
 * @version Jul 4, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a>
 */
public interface VehicleControlInterface
        extends
            EventListenerInterface,
            EventProducerInterface
{
    /**
     * This event signifies that the control has updated itself.
     */
    public static final EventType UPDATE = new EventType("UPDATE");

    /**
     * The PLANNING_CHANGED event signals a change of planning by the control.
     */
    public static final EventType PLANNING_CHANGED = new EventType(
            "PLANNING_CHANGED");

    /**
     * END_OF_SCHEDULED_SCENARIO is the event used for signalling the end of
     * scheduled scenario.
     *  
     */
    public static final EventType END_OF_SCHEDULED_SCENARIO = new EventType(
            "END_OF_SCHEDULED_SCENARIO");

    /**
     * This event is used by the vehiclePhysical to check a given scenario for
     * any relevant physical events.
     */
    public static final EventType CHECK_SCENARIO_FOR_PHYSICAL_EVENTS = new EventType(
            "CHECK_SCENARIO_FOR_PHYSICAL_EVENTS");

    /**
     * This event signals a change of acceleration
     */
    public static final EventType ACCELERATION_CHANGE = new EventType(
            "ACCELERATION_CHANGE");

    /**
     * this method is needed to tell the vehicle to start driving  
     */
    public void startDriving();

    /**
     * @return vehiclePhysical
     */
    public VehiclePhysicalInterface getVehiclePhysical();

    /**
     * @param vehiclePhysical The vehiclePhysical to set.
     * @throws Exception
     */
    public void setVehiclePhysical(VehiclePhysicalInterface vehiclePhysical)
            throws Exception;

    /**
     * remove the vehicle from the track
     * 
     * @throws RemoteException
     */
    public void removeVehicle() throws RemoteException;
    
    /**
     * @return Returns the line.
     */
    public String getLine();

}