/*
 * Created on Jun 25, 2003
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.vehicle;

import java.rmi.RemoteException;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.EventProducerInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.traffic.track.TrackInterface;

/**
 * This interface defines the behaviour of the physical part of a vehicle.
 * 
 * <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version Jul 4, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a>
 */
public interface VehiclePhysicalInterface
        extends
            EventProducerInterface,
            LocatableInterface,
            EventListenerInterface
{
    /**
     * This event signals that the vehicle is leaving the infrastructure.
     */
    public static final EventType REMOVE_EVENT = new EventType("REMOVE_EVENT");

    /**
     * this method is needed to tell the vehicle to start driving
     */
    public void startDriving();

    /**
     * Returns the vehicle's current acceleration
     * 
     * @param speed
     * @param progression
     * @return double
     */
    public double getCurrentAcceleration(final double speed,
            final double progression);

    /**
     * @param speed
     * @param progression
     * @return the new speed and progresssion if they have been changed
     */
    public double[] setSpeedAndProgression(final double speed,
            final double progression);

    /**
     * Sets the vehicle's maximum speed
     * 
     * @param speed
     */
    public void setMaximumSpeed(final double speed);

    /**
     * Returns the vehicle's current speed
     * 
     * @return double
     */
    public double getCurrentSpeed();

    /**
     * Returns the vehicle's current progression on the track where it is
     * located.
     * 
     * @return progression
     */
    public double getProgression();

    /**
     * Returns the vehicle's current track
     * 
     * @return Track
     */
    public TrackInterface getCurrentTrack();

    /**
     * Returns the location of a position 'distace' meters behind the front of
     * the vehicle
     * 
     * @param distance
     * @return
     */
    public Point3d getBackwardLocation(final double distance);

    /**
     * Returns the vehicleType.
     * 
     * @return vehicleType.
     */
    public VehicleType getVehicleType();

    /**
     * Returns the control associated to this physical vehicle.
     * 
     * @return vehicleControl
     */
    public VehicleControlInterface getVehicleControl();

    /**
     * @param vehicleControl The vehicleControl to set.
     */
    public void setVehicleControl(VehicleControlInterface vehicleControl);

    /**
     * this method is used for verification etc.
     * 
     * @return total distance the vehicle has traveled
     */
    public double getDistanceTraveled();

    /**
     * remove the vehicle from the track
     * 
     * @throws RemoteException
     */
    public void removeVehicle() throws RemoteException;
}