/*
 * @(#)VehicleSegment.java Jun 20, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.vehicle;

import java.awt.Color;
import java.rmi.RemoteException;
import javax.media.j3d.Bounds;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.traffic.animation.SegmentedVehicleAnimation;

/**
 * <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version Jun 20, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a>
 */
public class VehicleSegment implements LocatableInterface
{
    /** the vehicle */
    private VehiclePhysicalInterface vehicle;

    /** front delta to vehicle front */
    private double front;

    /** axle1 delta to vehicle front */
    private double axle1;

    /** axle2 delta to vehicle front */
    private double axle2;

    /** segment length */
    private double length;

    /**
     * @param vehicle
     * @param devs
     * @param color
     * @param front
     * @param axle1
     * @param axle2
     * @param length
     */
    public VehicleSegment(final VehiclePhysicalInterface vehicle,
            final DEVSSimulatorInterface devs, final Color color,
            final double front, final double axle1, final double axle2,
            final double length)
    {
        this.vehicle = vehicle;
        this.front = front;
        this.axle1 = axle1;
        this.axle2 = axle2;
        this.length = length;
        if (devs instanceof AnimatorInterface)
        {
            new SegmentedVehicleAnimation(this, devs, color);
        }
    }

    /**
     * @return Returns the axle1.
     */
    public double getAxle1()
    {
        return this.axle1;
    }

    /**
     * @return Returns the axle2.
     */
    public double getAxle2()
    {
        return this.axle2;
    }

    /**
     * @return Returns the front.
     */
    public double getFront()
    {
        return this.front;
    }

    /**
     * @return Returns the length.
     */
    public double getLength()
    {
        return this.length;
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.LocatableInterface#getLocation()
     */
    public DirectedPoint getLocation() throws RemoteException
    {
        Point3d front = this.vehicle.getBackwardLocation(this.front);
        Point3d back = this.vehicle.getBackwardLocation(this.front
                + this.length);
        double theta = Math.atan2(back.y - front.y, back.x - front.x);
        return new DirectedPoint(front.x, front.y, front.z + 0.05, 0, 0, theta);
    }

    /**
     * @see nl.tudelft.simulation.dsol.animation.LocatableInterface#getBounds()
     */
    public Bounds getBounds() throws RemoteException
    {
        DirectedPoint location = getLocation();
        double width = this.vehicle.getVehicleType().getWidth();
        // Bounds box = new BoundingSphere(new Point3d(), width / 2.0d);
        Bounds box = new BoundingBox(new Point3d(0, -width / 2.0, 0.0),
                new Point3d(this.length, width / 2.0, 0.0));
        Transform3D rot = new Transform3D();
        rot.rotZ(location.getRotZ());
        box.transform(rot);
        return box;
    }

    /**
     * @return Returns the vehicle.
     */
    public VehiclePhysicalInterface getVehicle()
    {
        return this.vehicle;
    }
}