/*
 * @(#)VehicleType.java Jun 14, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.traffic.vehicle;

import java.awt.Color;
import java.util.ArrayList;

/**
 * The data of a vehicle that can be generated or constructed. <br>
 * <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General
 * Public License (GPL) </a>, no warranty <br>
 * 
 * @version Jun 14, 2004 <br>
 * @author <a
 * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 * Verbraeck </a>
 */
public class VehicleType
{
    /** the name of the vehicle */
    private String name;

    /** the total length of the vehicle */
    private double length;

    /** the width of the vehicle */
    private double width;

    /** the color of the vehicle in the animation */
    private Color color;

    /** the segment information */
    private ArrayList segments = new ArrayList();

    /** the sequence number */
    private int number = 0;

    /** vehicle maximum speed */
    private double vehicleMaximumSpeed;

    /** the acceleration profile */
    private AccelerationProfile accelerationProfile;

    /** the deceleration profile */
    private DecelerationProfile decelerationProfile;

    /**
     * Create a new vehicle type
     */
    public VehicleType()
    {
        super();
    }

    /**
     * @return Returns the color.
     */
    public Color getColor()
    {
        return this.color;
    }

    /**
     * @param color The color to set.
     */
    public void setColor(Color color)
    {
        this.color = color;
    }

    /**
     * @return Returns the length.
     */
    public double getLength()
    {
        return this.length;
    }

    /**
     * @param length The length to set.
     */
    public void setLength(double length)
    {
        this.length = length;
    }

    /**
     * @return Returns the name.
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * @param name The name to set.
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @return Returns the width.
     */
    public double getWidth()
    {
        return this.width;
    }

    /**
     * @param width The width to set.
     */
    public void setWidth(double width)
    {
        this.width = width;
    }

    /**
     * @param front
     * @param axle1
     * @param axle2
     * @param length
     */
    public void addSegment(final double front, final double axle1,
            final double axle2, final double length)
    {
        Segment segment = new Segment(front, axle1, axle2, length);
        this.segments.add(segment);
    }

    /**
     * @return Returns the segments.
     */
    public ArrayList getSegments()
    {
        return this.segments;
    }

    /**
     * @return Returns the vehicleMaximumSpeed.
     */
    public double getVehicleMaximumSpeed()
    {
        return this.vehicleMaximumSpeed;
    }

    /**
     * @param vehicleMaximumSpeed The vehicleMaximumSpeed to set.
     */
    public void setVehicleMaximumSpeed(double vehicleMaximumSpeed)
    {
        this.vehicleMaximumSpeed = vehicleMaximumSpeed;
    }

    /**
     * @return Returns the accelerationProfile.
     */
    public AccelerationProfile getAccelerationProfile()
    {
        return this.accelerationProfile;
    }

    /**
     * @param accelerationProfile The accelerationProfile to set.
     */
    public void setAccelerationProfile(AccelerationProfile accelerationProfile)
    {
        this.accelerationProfile = accelerationProfile;
        this.accelerationProfile.initializeProfile();
    }

    /**
     * @return Returns the decelerationProfile.
     */
    public DecelerationProfile getDecelerationProfile()
    {
        return this.decelerationProfile;
    }

    /**
     * @param decelerationProfile The decelerationProfile to set.
     */
    public void setDecelerationProfile(DecelerationProfile decelerationProfile)
    {
        this.decelerationProfile = decelerationProfile;
        this.decelerationProfile.initializeProfile();
    }

    /**
     * @return a unique name for this type
     */
    public String generateUniqueName()
    {
        this.number++;
        return this.name + "." + this.number;
    }

    /**
     * The segment information for a segmented vehicle.
     * 
     * <br>
     * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
     * University of Technology </a>, the Netherlands. <br>
     * See for project information <a href="http://www.simulation.tudelft.nl">
     * www.simulation.tudelft.nl </a> <br>
     * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General
     * Public License (GPL) </a>, no warranty <br>
     * 
     * @version Jun 20, 2004 <br>
     * @author <a
     * href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
     * Verbraeck </a>
     */
    public class Segment
    {
        /** front delta to vehicle front */
        private double front;

        /** axle1 delta to vehicle front */
        private double axle1;

        /** axle2 delta to vehicle front */
        private double axle2;

        /** segment length */
        private double length;

        /**
         * @param front
         * @param axle1
         * @param axle2
         * @param length
         */
        public Segment(final double front, final double axle1,
                final double axle2, final double length)
        {
            this.front = front;
            this.axle1 = axle1;
            this.axle2 = axle2;
            this.length = length;
        }

        /**
         * @return Returns the axle1.
         */
        public double getAxle1()
        {
            return this.axle1;
        }

        /**
         * @return Returns the axle2.
         */
        public double getAxle2()
        {
            return this.axle2;
        }

        /**
         * @return Returns the front.
         */
        public double getFront()
        {
            return this.front;
        }

        /**
         * @return Returns the length.
         */
        public double getLength()
        {
            return this.length;
        }
    }
}
